/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability;

import org.evosuite.instrumentation.BooleanTestabilityTransformation;
import org.evosuite.instrumentation.testability.MethodNodeTransformer;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class BooleanArrayTransformer
extends MethodNodeTransformer {
    @Override
    protected AbstractInsnNode transformIntInsnNode(MethodNode mn, IntInsnNode intInsnNode) {
        if (intInsnNode.operand == 4) {
            intInsnNode.operand = 10;
        }
        return intInsnNode;
    }

    @Override
    protected AbstractInsnNode transformMultiANewArrayInsnNode(MethodNode mn, MultiANewArrayInsnNode arrayInsnNode) {
        String new_desc = "";
        Type t = Type.getType(arrayInsnNode.desc);
        while (t.getSort() == 9) {
            new_desc = new_desc + "[";
            t = t.getElementType();
        }
        new_desc = t.equals(Type.BOOLEAN_TYPE) ? new_desc + "I" : new_desc + t.getDescriptor();
        arrayInsnNode.desc = new_desc;
        return arrayInsnNode;
    }

    @Override
    protected AbstractInsnNode transformTypeInsnNode(MethodNode mn, TypeInsnNode typeNode) {
        int pos;
        String new_desc = "";
        for (pos = 0; pos < typeNode.desc.length() && typeNode.desc.charAt(pos) == '['; ++pos) {
            new_desc = new_desc + "[";
        }
        String d = typeNode.desc.substring(pos);
        BooleanTestabilityTransformation.logger.info("Unfolded arrays to: " + d);
        new_desc = d.equals("Z") ? new_desc + "I" : new_desc + d;
        typeNode.desc = new_desc;
        return typeNode;
    }
}

