/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability;

import org.evosuite.instrumentation.BooleanHelper;
import org.evosuite.instrumentation.BooleanTestabilityTransformation;
import org.evosuite.instrumentation.DescriptorMapping;
import org.evosuite.instrumentation.TransformationStatistics;
import org.evosuite.instrumentation.testability.MethodNodeTransformer;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Frame;

public class BooleanIfTransformer
extends MethodNodeTransformer {
    private final BooleanTestabilityTransformation booleanTestabilityTransformation;

    public BooleanIfTransformer(BooleanTestabilityTransformation booleanTestabilityTransformation) {
        this.booleanTestabilityTransformation = booleanTestabilityTransformation;
    }

    @Override
    protected AbstractInsnNode transformJumpInsnNode(MethodNode mn, JumpInsnNode jumpNode) {
        if (jumpNode.getOpcode() == 154) {
            if (this.booleanTestabilityTransformation.isBooleanOnStack(mn, jumpNode, 0)) {
                TransformationStatistics.transformedBooleanComparison();
                BooleanTestabilityTransformation.logger.info("Changing IFNE");
                jumpNode.setOpcode(157);
            } else {
                BooleanTestabilityTransformation.logger.info("Not changing IFNE");
                int insnPosition = mn.instructions.indexOf(jumpNode);
                Frame frame = this.booleanTestabilityTransformation.currentFrames[insnPosition];
                AbstractInsnNode insn = mn.instructions.get(insnPosition - 1);
                BooleanTestabilityTransformation.logger.info("Current node: " + mn.instructions.get(insnPosition));
                BooleanTestabilityTransformation.logger.info("Previous node: " + insn);
                if (insn instanceof MethodInsnNode) {
                    MethodInsnNode mi = (MethodInsnNode)insn;
                    if (Type.getReturnType(DescriptorMapping.getInstance().getMethodDesc(mi.owner, mi.name, mi.desc)) == Type.BOOLEAN_TYPE) {
                        BooleanTestabilityTransformation.logger.info("Changing IFNE");
                        jumpNode.setOpcode(157);
                    }
                    BooleanTestabilityTransformation.logger.info("Method: " + mi.name);
                }
                BooleanTestabilityTransformation.logger.info("Stack size: " + frame.getStackSize());
                for (int i = 0; i < frame.getStackSize(); ++i) {
                    BooleanTestabilityTransformation.logger.info(i + " Stack: " + frame.getStack(i));
                }
            }
        } else if (jumpNode.getOpcode() == 153) {
            if (this.booleanTestabilityTransformation.isBooleanOnStack(mn, jumpNode, 0)) {
                TransformationStatistics.transformedBooleanComparison();
                BooleanTestabilityTransformation.logger.info("Changing IFEQ");
                jumpNode.setOpcode(158);
            } else {
                BooleanTestabilityTransformation.logger.info("Not changing IFEQ");
                int insnPosition = mn.instructions.indexOf(jumpNode);
                Frame frame = this.booleanTestabilityTransformation.currentFrames[insnPosition];
                AbstractInsnNode insn = mn.instructions.get(insnPosition - 1);
                BooleanTestabilityTransformation.logger.info("Previous node: " + insn);
                if (insn instanceof MethodInsnNode) {
                    MethodInsnNode mi = (MethodInsnNode)insn;
                    BooleanTestabilityTransformation.logger.info("Method: " + mi.name);
                    if (Type.getReturnType(BooleanTestabilityTransformation.getOriginalDesc(mi.owner, mi.name, mi.desc)) == Type.BOOLEAN_TYPE) {
                        BooleanTestabilityTransformation.logger.info("Changing IFEQ");
                        jumpNode.setOpcode(158);
                    } else {
                        BooleanTestabilityTransformation.logger.info("Return type: " + Type.getReturnType(BooleanTestabilityTransformation.getOriginalDesc(mi.owner, mi.name, mi.desc)));
                    }
                }
                BooleanTestabilityTransformation.logger.info("Stack size: " + frame.getStackSize());
                for (int i = 0; i < frame.getStackSize(); ++i) {
                    BooleanTestabilityTransformation.logger.info(i + " Stack: " + frame.getStack(i));
                }
            }
        } else if (jumpNode.getOpcode() == 159) {
            if (this.booleanTestabilityTransformation.isBooleanOnStack(mn, jumpNode, 0)) {
                InsnList convert = new InsnList();
                convert.add(new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "pushParameter", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE)));
                convert.add(new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "pushParameter", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE)));
                convert.add(new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "popParameterBooleanFromInt", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0])));
                convert.add(new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "popParameterBooleanFromInt", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0])));
                mn.instructions.insertBefore((AbstractInsnNode)jumpNode, convert);
                TransformationStatistics.transformedBooleanComparison();
            }
        } else if (jumpNode.getOpcode() == 160 && this.booleanTestabilityTransformation.isBooleanOnStack(mn, jumpNode, 0)) {
            InsnList convert = new InsnList();
            convert.add(new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "pushParameter", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE)));
            convert.add(new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "pushParameter", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE)));
            convert.add(new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "popParameterBooleanFromInt", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0])));
            convert.add(new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "popParameterBooleanFromInt", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0])));
            mn.instructions.insertBefore((AbstractInsnNode)jumpNode, convert);
            TransformationStatistics.transformedBooleanComparison();
        }
        return jumpNode;
    }
}

