/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.junit.JUnitFailure;
import org.evosuite.testcase.ExecutionTrace;

public class JUnitResult {
    private String name;
    private boolean successful;
    private long runtime;
    private String trace;
    private ExecutionTrace executionTrace;
    private int failureCount;
    private int runCount;
    private ArrayList<JUnitFailure> junitFailures = new ArrayList();

    public JUnitResult(String name) {
        this.successful = true;
        this.name = name;
        this.failureCount = 0;
        this.runCount = 0;
    }

    public JUnitResult(boolean wasSuccessful, int failureCount, int runCount) {
        this.successful = wasSuccessful;
        this.failureCount = failureCount;
        this.runCount = runCount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public boolean wasSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean s) {
        this.successful = s;
    }

    public long getRuntime() {
        return this.runtime;
    }

    public void setRuntime(long r) {
        this.runtime = r;
    }

    public String getTrace() {
        return this.trace;
    }

    public void setTrace(String t) {
        this.trace = t;
    }

    public ExecutionTrace getExecutionTrace() {
        return this.executionTrace;
    }

    public void setExecutionTrace(ExecutionTrace et) {
        this.executionTrace = et;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public void incrementFailureCount() {
        ++this.failureCount;
    }

    public int getRunCount() {
        return this.runCount;
    }

    public void incrementRunCount() {
        ++this.runCount;
    }

    public List<JUnitFailure> getFailures() {
        return this.junitFailures;
    }

    public void addFailure(JUnitFailure junitFailure) {
        this.junitFailures.add(junitFailure);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.failureCount;
        result = 31 * result + (this.junitFailures == null ? 0 : this.junitFailures.hashCode());
        result = 31 * result + this.runCount;
        result = 31 * result + (this.successful ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JUnitResult other = (JUnitResult)obj;
        if (this.failureCount != other.failureCount) {
            return false;
        }
        if (this.junitFailures == null ? other.junitFailures != null : !this.junitFailures.equals(other.junitFailures)) {
            return false;
        }
        if (this.runCount != other.runCount) {
            return false;
        }
        return this.successful == other.successful;
    }
}

