/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.ExecutionTrace;
import org.evosuite.testcase.ExecutionTracer;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCaseExecutor;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.junit.runner.JUnitCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitTestSuite {
    private static Logger logger = LoggerFactory.getLogger(JUnitTestSuite.class);
    private Set<String> coveredMethods;
    private Set<Integer> coveredBranchesTrue;
    private Set<Integer> coveredBranchesFalse;
    private final TestCaseExecutor executor = TestCaseExecutor.getInstance();

    public void runSuite(String name) {
        try {
            Class<?> forName = null;
            forName = Class.forName(name);
            logger.info("Running against JUnit test suite " + name);
            JUnitCore.runClasses(forName);
            ExecutionTrace trace = ExecutionTracer.getExecutionTracer().getTrace();
            this.coveredMethods = new HashSet<String>();
            this.coveredBranchesTrue = trace.getCoveredTrueBranches();
            this.coveredBranchesFalse = trace.getCoveredFalseBranches();
            for (String methodName : trace.getCoveredMethods()) {
                if (methodName.contains("$")) continue;
                this.coveredMethods.add(methodName);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void runSuite(TestSuiteChromosome chromosome) {
        this.coveredMethods = new HashSet<String>();
        this.coveredBranchesTrue = new HashSet<Integer>();
        this.coveredBranchesFalse = new HashSet<Integer>();
        for (TestCase test : chromosome.getTests()) {
            ExecutionResult result = this.runTest(test);
            this.coveredMethods.addAll(result.getTrace().getCoveredMethods());
            this.coveredBranchesTrue.addAll(result.getTrace().getCoveredTrueBranches());
            this.coveredBranchesFalse.addAll(result.getTrace().getCoveredFalseBranches());
        }
    }

    public Set<String> getCoveredMethods() {
        return this.coveredMethods;
    }

    public Set<Integer> getTrueCoveredBranches() {
        return this.coveredBranchesTrue;
    }

    public Set<Integer> getFalseCoveredBranches() {
        return this.coveredBranchesFalse;
    }

    public ExecutionResult runTest(TestCase test) {
        ExecutionResult result = new ExecutionResult(test, null);
        try {
            logger.debug("Executing test");
            result = this.executor.execute(test);
            int num = test.size();
            MaxStatementsStoppingCondition.statementsExecuted(num);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return result;
    }
}

