/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit.writer;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.DebugGraphics;
import org.apache.commons.lang3.StringUtils;
import org.evosuite.Properties;
import org.evosuite.coverage.dataflow.DefUseCoverageTestFitness;
import org.evosuite.junit.UnitTestAdapter;
import org.evosuite.junit.writer.Scaffolding;
import org.evosuite.junit.writer.TestSuiteWriterUtils;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.EvoSuiteFile;
import org.evosuite.testcase.CodeUnderTestException;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.StructuredTestCase;
import org.evosuite.testcase.StructuredTestCodeVisitor;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCaseExecutor;
import org.evosuite.testcase.TestCodeVisitor;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.Utils;
import org.junit.runner.RunWith;
import org.objectweb.asm.Opcodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteWriter
implements Opcodes {
    protected static final Logger logger = LoggerFactory.getLogger(TestSuiteWriter.class);
    protected TestCaseExecutor executor = TestCaseExecutor.getInstance();
    protected List<TestCase> testCases = new ArrayList<TestCase>();
    protected Map<Integer, String> testComment = new HashMap<Integer, String>();
    private final UnitTestAdapter adapter = TestSuiteWriterUtils.getAdapter();
    private TestCodeVisitor visitor = Properties.ASSERTION_STRATEGY == Properties.AssertionStrategy.STRUCTURED ? (this.visitor = new StructuredTestCodeVisitor()) : new TestCodeVisitor();
    private final Map<String, Integer> testMethodNumber = new HashMap<String, Integer>();

    public int insertTest(TestCase test) {
        if (Properties.CALL_PROBABILITY <= 0.0) {
            for (int i = 0; i < this.testCases.size(); ++i) {
                if (test.isPrefix(this.testCases.get(i))) {
                    logger.info("This is a prefix of an existing test");
                    this.testCases.get(i).addAssertions(test);
                    return i;
                }
                if (!this.testCases.get(i).isPrefix(test)) continue;
                test.addAssertions(this.testCases.get(i));
                this.testCases.set(i, test);
                logger.info("We have a prefix of this one");
                return i;
            }
        }
        logger.info("Adding new test case:");
        if (logger.isDebugEnabled()) {
            logger.debug(test.toCode());
        }
        this.testCases.add(test);
        return this.testCases.size() - 1;
    }

    public int insertTest(TestCase test, String comment) {
        int id = this.insertTest(test);
        if (this.testComment.containsKey(id)) {
            if (!this.testComment.get(id).contains(comment)) {
                this.testComment.put(id, this.testComment.get(id) + "\n" + "  " + "//" + comment);
            }
        } else {
            this.testComment.put(id, comment);
        }
        return id;
    }

    public void insertTests(List<TestCase> tests) {
        for (TestCase test : tests) {
            this.insertTest(test);
        }
    }

    public void insertAllTests(List<TestCase> tests) {
        this.testCases.addAll(tests);
    }

    public List<TestCase> getTestCases() {
        return this.testCases;
    }

    public List<File> writeTestSuite(String name, String directory) throws IllegalArgumentException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Empty test class name");
        }
        if (!name.endsWith("Test")) {
            throw new IllegalArgumentException("Test classes should have name ending with 'Test'. Invalid input name: " + name);
        }
        ArrayList<ExecutionResult> results = new ArrayList<ExecutionResult>();
        ArrayList<File> generated = new ArrayList<File>();
        String dir = TestSuiteWriterUtils.makeDirectory(directory);
        String content = "";
        if (Properties.OUTPUT_GRANULARITY == Properties.OutputGranularity.MERGED) {
            File file = new File(dir + "/" + name + ".java");
            this.executor.newObservers();
            content = this.getUnitTestsAllInSameFile(name, results);
            Utils.writeFile(content, file);
            generated.add(file);
        } else {
            for (int i = 0; i < this.testCases.size(); ++i) {
                String testSuiteName = name.substring(0, name.length() - "Test".length()) + "_" + i + "_Test";
                File file = new File(dir + "/" + testSuiteName + ".java");
                this.executor.newObservers();
                String testCode = this.getOneUnitTestInAFile(name, i, results);
                Utils.writeFile(testCode, file);
                content = content + testCode;
                generated.add(file);
            }
        }
        if (Properties.TEST_SCAFFOLDING) {
            String scaffoldingName = Scaffolding.getFileName(name);
            File file = new File(dir + "/" + scaffoldingName + ".java");
            String scaffoldingContent = Scaffolding.getScaffoldingFileContent(name, results, TestSuiteWriterUtils.hasAnySecurityException(results));
            Utils.writeFile(scaffoldingContent, file);
            generated.add(file);
            content = content + scaffoldingContent;
        }
        TestGenerationResultBuilder.getInstance().setTestSuiteCode(content);
        return generated;
    }

    private String getUnitTestsAllInSameFile(String name, List<ExecutionResult> results) {
        for (int i = 0; i < this.testCases.size(); ++i) {
            ExecutionResult result = this.runTest(this.testCases.get(i));
            results.add(result);
        }
        boolean wasSecurityException = TestSuiteWriterUtils.hasAnySecurityException(results);
        StringBuilder builder = new StringBuilder();
        builder.append(this.getHeader(name, results));
        if (!Properties.TEST_SCAFFOLDING) {
            builder.append(new Scaffolding().getBeforeAndAfterMethods(name, wasSecurityException, results));
        }
        for (int i = 0; i < this.testCases.size(); ++i) {
            builder.append(this.testToString(i, i, results.get(i)));
        }
        builder.append(this.getFooter());
        return builder.toString();
    }

    private String getOneUnitTestInAFile(String name, int testId, List<ExecutionResult> results) {
        ExecutionResult result = this.runTest(this.testCases.get(testId));
        results.add(result);
        boolean wasSecurityException = result.hasSecurityException();
        StringBuilder builder = new StringBuilder();
        builder.append(this.getHeader(name + "_" + testId, results));
        if (!Properties.TEST_SCAFFOLDING) {
            builder.append(new Scaffolding().getBeforeAndAfterMethods(name, wasSecurityException, results));
        }
        builder.append(this.testToString(testId, testId, results.get(0)));
        builder.append(this.getFooter());
        return builder.toString();
    }

    protected ExecutionResult runTest(TestCase test) {
        ExecutionResult result = new ExecutionResult(test, null);
        try {
            logger.debug("Executing test");
            result = this.executor.execute(test);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return result;
    }

    protected String getImports(List<ExecutionResult> results) {
        StringBuilder builder = new StringBuilder();
        HashSet imports = new HashSet();
        boolean wasSecurityException = TestSuiteWriterUtils.hasAnySecurityException(results);
        for (ExecutionResult result : results) {
            result.test.accept(this.visitor);
            for (Throwable t : result.getAllThrownExceptions()) {
                this.visitor.getClassName(t.getClass());
            }
            imports.addAll(this.visitor.getImports());
        }
        if (Properties.RESET_STANDARD_STREAMS) {
            imports.add(PrintStream.class);
            imports.add(DebugGraphics.class);
        }
        if (TestSuiteWriterUtils.needToUseAgent()) {
            imports.add(EvoRunner.class);
            imports.add(EvoRunnerParameters.class);
            imports.add(RunWith.class);
        }
        HashSet<String> import_names = new HashSet<String>();
        for (Class<?> imp : imports) {
            String name;
            while (imp.isArray()) {
                imp = imp.getComponentType();
            }
            if (imp.isPrimitive() || imp.getName().startsWith("java.lang") && !(name = imp.getName().replace("java.lang.", "")).contains(".") || !imp.getName().contains(".")) continue;
            if (imp.getName().contains("$")) {
                import_names.add(imp.getName().replace("$", "."));
                continue;
            }
            import_names.add(imp.getName());
        }
        if (Properties.VIRTUAL_FS) {
            import_names.add(EvoSuiteFile.class.getCanonicalName());
        }
        if (wasSecurityException) {
            import_names.add(ExecutorService.class.getCanonicalName());
            import_names.add(Executors.class.getCanonicalName());
            import_names.add(Future.class.getCanonicalName());
            import_names.add(TimeUnit.class.getCanonicalName());
        }
        if (!Properties.TEST_SCAFFOLDING) {
            import_names.addAll(Scaffolding.getScaffoldingImports(wasSecurityException, results));
        }
        ArrayList imports_sorted = new ArrayList(import_names);
        Collections.sort(imports_sorted);
        for (String imp : imports_sorted) {
            builder.append("import ");
            builder.append(imp);
            builder.append(";\n");
        }
        builder.append("\n");
        return builder.toString();
    }

    protected String getHeader(String name, List<ExecutionResult> results) {
        StringBuilder builder = new StringBuilder();
        builder.append("/*\n");
        builder.append(" * This file was automatically generated by EvoSuite\n");
        builder.append(" * " + new Date() + "\n");
        builder.append(" */\n\n");
        if (!Properties.CLASS_PREFIX.equals("")) {
            builder.append("package ");
            builder.append(Properties.CLASS_PREFIX);
            builder.append(";\n");
        }
        builder.append("\n");
        builder.append(this.adapter.getImports());
        builder.append(this.getImports(results));
        if (TestSuiteWriterUtils.needToUseAgent()) {
            builder.append(this.getRunner());
        }
        builder.append(this.adapter.getClassDefinition(name));
        if (Properties.TEST_SCAFFOLDING) {
            builder.append(" extends " + Scaffolding.getFileName(name));
        }
        builder.append(" {\n");
        return builder.toString();
    }

    private Object getRunner() {
        String s = "@RunWith(EvoRunner.class) @EvoRunnerParameters(";
        ArrayList<String> list = new ArrayList<String>();
        if (Properties.REPLACE_CALLS) {
            list.add("mockJVMNonDeterminism = true");
        }
        if (Properties.VIRTUAL_FS) {
            list.add("useVFS = true");
        }
        if (Properties.RESET_STATIC_FIELDS) {
            list.add("resetStaticState = true");
        }
        if (!list.isEmpty()) {
            s = s + (String)list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                s = s + ", " + (String)list.get(i);
            }
        }
        s = s + ") \n";
        return s;
    }

    protected String getFooter() {
        return "}\n";
    }

    protected String testToString(int number, int id, ExecutionResult result) {
        Set<Class<?>> exceptions;
        String methodName;
        boolean wasSecurityException = result.hasSecurityException();
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        if (Properties.TEST_COMMENTS || this.testComment.containsKey(id)) {
            builder.append("  ");
            builder.append("//");
            builder.append(this.getInformation(id));
            builder.append("\n");
        }
        if (Properties.ASSERTION_STRATEGY == Properties.AssertionStrategy.STRUCTURED) {
            StructuredTestCase structuredTest = (StructuredTestCase)this.testCases.get(id);
            String targetMethod = structuredTest.getTargetMethods().iterator().next();
            if ((targetMethod = targetMethod.replace("<init>", "Constructor")).indexOf(40) != -1) {
                targetMethod = targetMethod.substring(0, targetMethod.indexOf(40));
            }
            targetMethod = StringUtils.capitalize(targetMethod);
            int num = 0;
            if (this.testMethodNumber.containsKey(targetMethod)) {
                num = this.testMethodNumber.get(targetMethod);
                this.testMethodNumber.put(targetMethod, num + 1);
            } else {
                this.testMethodNumber.put(targetMethod, 1);
            }
            methodName = "test" + targetMethod + num;
            builder.append(this.adapter.getMethodDefinition(methodName));
        } else {
            methodName = TestSuiteWriterUtils.getNameOfTest(this.testCases, number);
            builder.append(this.adapter.getMethodDefinition(methodName));
        }
        builder.append(" throws Throwable ");
        builder.append(" {\n");
        String CODE_SPACE = "      ";
        TestCase test = this.testCases.get(id);
        Integer pos = result.getFirstPositionOfThrownException();
        if (pos != null) {
            if (result.getExceptionThrownAtPosition(pos) instanceof CodeUnderTestException) {
                test.chop(pos);
            } else {
                test.chop(pos + 1);
            }
        }
        if (wasSecurityException) {
            builder.append("    ");
            builder.append("Future<?> future = executor.submit(new Runnable(){ \n");
            builder.append("      ");
            builder.append("      ");
            builder.append("@Override public void run() { \n");
            exceptions = test.getDeclaredExceptions();
            if (!exceptions.isEmpty()) {
                builder.append("        ");
                builder.append("try {\n");
            }
            CODE_SPACE = "          ";
        }
        for (String line : this.adapter.getTestString(id, test, result.exposeExceptionMapping(), this.visitor).split("\\r?\\n")) {
            builder.append(CODE_SPACE);
            builder.append(line);
            builder.append("\n");
        }
        if (wasSecurityException) {
            exceptions = test.getDeclaredExceptions();
            if (!exceptions.isEmpty()) {
                builder.append("        ");
                builder.append("} catch(Throwable t) {\n");
                builder.append("          ");
                builder.append("  // Need to catch declared exceptions\n");
                builder.append("        ");
                builder.append("}\n");
            }
            builder.append("      ");
            builder.append("} \n");
            builder.append("    ");
            builder.append("}); \n");
            long time = Properties.TIMEOUT + 1000;
            builder.append("    ");
            builder.append("future.get(" + time + ", TimeUnit.MILLISECONDS); \n");
        }
        builder.append("  ");
        builder.append("}\n");
        String testCode = builder.toString();
        TestGenerationResultBuilder.getInstance().setTestCase(methodName, testCode, test, this.getInformation(id), result);
        return testCode;
    }

    protected String getInformation(int num) {
        if (this.testComment.containsKey(num)) {
            String comment = this.testComment.get(num);
            if (!comment.endsWith("\n")) {
                comment = comment + "\n";
            }
            return comment;
        }
        TestCase test = this.testCases.get(num);
        Set<TestFitnessFunction> coveredGoals = test.getCoveredGoals();
        StringBuilder builder = new StringBuilder();
        builder.append("Test case number: " + num);
        if (!coveredGoals.isEmpty()) {
            builder.append("\n  /*\n");
            builder.append("   * ");
            builder.append(coveredGoals.size() + " covered goal");
            if (coveredGoals.size() != 1) {
                builder.append("s");
            }
            builder.append(":");
            int nr = 1;
            for (TestFitnessFunction goal : coveredGoals) {
                DefUseCoverageTestFitness duGoal;
                builder.append("\n   * " + nr + " " + goal.toString());
                if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) && goal instanceof DefUseCoverageTestFitness && (duGoal = (DefUseCoverageTestFitness)goal).getCoveringTrace() != null) {
                    String traceInformation = duGoal.getCoveringTrace().toDefUseTraceInformation(duGoal.getGoalVariable(), duGoal.getCoveringObjectId());
                    traceInformation = traceInformation.replaceAll("\n", "");
                    builder.append("\n     * DUTrace: " + traceInformation);
                }
                ++nr;
            }
            builder.append("\n   */\n");
        }
        return builder.toString();
    }
}

