/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.result;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.assertion.Assertion;
import org.evosuite.contracts.ContractViolation;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.coverage.mutation.MutationTimeoutStoppingCondition;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.instrumentation.LinePool;
import org.evosuite.result.BranchInfo;
import org.evosuite.result.Failure;
import org.evosuite.result.MutationInfo;
import org.evosuite.result.TestGenerationResult;
import org.evosuite.result.TestGenerationResultImpl;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.TestCase;
import org.evosuite.utils.LoggingUtils;

public class TestGenerationResultBuilder {
    private static TestGenerationResultBuilder instance = null;
    private String code = "";
    private GeneticAlgorithm<?> ga = null;
    private Map<String, String> testCode = new LinkedHashMap<String, String>();
    private Map<String, TestCase> testCases = new LinkedHashMap<String, TestCase>();
    private Map<String, String> testComments = new LinkedHashMap<String, String>();
    private Map<String, Set<Integer>> testLineCoverage = new LinkedHashMap<String, Set<Integer>>();
    private Map<String, Set<BranchInfo>> testBranchCoverage = new LinkedHashMap<String, Set<BranchInfo>>();
    private Map<String, Set<MutationInfo>> testMutantCoverage = new LinkedHashMap<String, Set<MutationInfo>>();
    private Map<String, Set<Failure>> contractViolations = new LinkedHashMap<String, Set<Failure>>();
    private Set<Integer> uncoveredLines = LinePool.getAllLines();
    private Set<BranchInfo> uncoveredBranches = new LinkedHashSet<BranchInfo>();
    private Set<MutationInfo> uncoveredMutants = new LinkedHashSet<MutationInfo>();
    private LinkedHashMap<FitnessFunction<?>, Double> targetCoverages = new LinkedHashMap();

    public static TestGenerationResult buildErrorResult(String errorMessage) {
        TestGenerationResultImpl result = new TestGenerationResultImpl();
        result.setStatus(TestGenerationResult.Status.ERROR);
        result.setErrorMessage(errorMessage);
        TestGenerationResultBuilder.getInstance().fillInformationFromConfiguration(result);
        TestGenerationResultBuilder.getInstance().fillInformationFromTestData(result);
        TestGenerationResultBuilder.getInstance().resetTestData();
        return result;
    }

    public static TestGenerationResult buildTimeoutResult() {
        TestGenerationResultImpl result = new TestGenerationResultImpl();
        result.setStatus(TestGenerationResult.Status.TIMEOUT);
        TestGenerationResultBuilder.getInstance().fillInformationFromConfiguration(result);
        TestGenerationResultBuilder.getInstance().fillInformationFromTestData(result);
        TestGenerationResultBuilder.getInstance().resetTestData();
        return result;
    }

    public static TestGenerationResult buildSuccessResult() {
        TestGenerationResultImpl result = new TestGenerationResultImpl();
        result.setStatus(TestGenerationResult.Status.SUCCESS);
        TestGenerationResultBuilder.getInstance().fillInformationFromConfiguration(result);
        TestGenerationResultBuilder.getInstance().fillInformationFromTestData(result);
        TestGenerationResultBuilder.getInstance().resetTestData();
        return result;
    }

    private TestGenerationResultBuilder() {
        this.resetTestData();
    }

    public static TestGenerationResultBuilder getInstance() {
        if (instance == null) {
            instance = new TestGenerationResultBuilder();
        }
        return instance;
    }

    private void resetTestData() {
        this.code = "";
        this.ga = null;
        this.testCode.clear();
        this.testCases.clear();
        this.contractViolations.clear();
        this.uncoveredLines = LinePool.getAllLines();
        for (Branch b : BranchPool.getAllBranches()) {
            this.uncoveredBranches.add(new BranchInfo(b, true));
            this.uncoveredBranches.add(new BranchInfo(b, false));
        }
        for (Mutation m : MutationPool.getMutants()) {
            this.uncoveredMutants.add(new MutationInfo(m));
        }
    }

    private void fillInformationFromConfiguration(TestGenerationResultImpl result) {
        result.setClassUnderTest(Properties.TARGET_CLASS);
        String[] criteria = new String[Properties.CRITERION.length];
        for (int i = 0; i < Properties.CRITERION.length; ++i) {
            criteria[i] = Properties.CRITERION[i].name();
        }
        result.setTargetCriterion(criteria);
    }

    private void fillInformationFromTestData(TestGenerationResultImpl result) {
        LinkedHashSet<MutationInfo> exceptionMutants = new LinkedHashSet<MutationInfo>();
        for (Mutation mutation : MutationPool.getMutants()) {
            if (!MutationTimeoutStoppingCondition.isDisabled(mutation)) continue;
            MutationInfo info = new MutationInfo(mutation);
            exceptionMutants.add(info);
            this.uncoveredMutants.remove(info);
        }
        for (String string : this.testCode.keySet()) {
            result.setTestCode(string, this.testCode.get(string));
            result.setTestCase(string, this.testCases.get(string));
            result.setContractViolations(string, this.contractViolations.get(string));
            result.setCoveredLines(string, this.testLineCoverage.get(string));
            result.setCoveredBranches(string, this.testBranchCoverage.get(string));
            result.setCoveredMutants(string, this.testMutantCoverage.get(string));
            result.setComment(string, this.testComments.get(string));
        }
        result.setUncoveredLines(this.uncoveredLines);
        result.setUncoveredBranches(this.uncoveredBranches);
        result.setUncoveredMutants(this.uncoveredMutants);
        result.setExceptionMutants(exceptionMutants);
        result.setTestSuiteCode(this.code);
        result.setGeneticAlgorithm(this.ga);
        for (Map.Entry entry : this.targetCoverages.entrySet()) {
            result.setTargetCoverage((FitnessFunction)entry.getKey(), (Double)entry.getValue());
        }
    }

    public void setTestCase(String name, String code, TestCase testCase, String comment, ExecutionResult result) {
        BranchInfo info;
        Branch branch;
        this.testCode.put(name, code);
        this.testCases.put(name, testCase);
        LinkedHashSet<Failure> failures = new LinkedHashSet<Failure>();
        for (ContractViolation violation : testCase.getContractViolations()) {
            failures.add(new Failure(violation));
        }
        if (!Properties.CHECK_CONTRACTS && result.hasUndeclaredException()) {
            int position = result.getFirstPositionOfThrownException();
            Throwable exception = result.getExceptionThrownAtPosition(position);
            failures.add(new Failure(exception, position, testCase));
        }
        this.contractViolations.put(name, failures);
        this.testComments.put(name, comment);
        this.testLineCoverage.put(name, result.getTrace().getCoveredLines());
        this.uncoveredLines.removeAll(result.getTrace().getCoveredLines());
        LinkedHashSet<BranchInfo> branchCoverage = new LinkedHashSet<BranchInfo>();
        for (int branchId : result.getTrace().getCoveredFalseBranches()) {
            branch = BranchPool.getBranch(branchId);
            if (branch == null) {
                LoggingUtils.getEvoLogger().warn("Branch is null: " + branchId);
                continue;
            }
            info = new BranchInfo(branch.getClassName(), branch.getMethodName(), branch.getInstruction().getLineNumber(), false);
            branchCoverage.add(info);
        }
        for (int branchId : result.getTrace().getCoveredTrueBranches()) {
            branch = BranchPool.getBranch(branchId);
            if (branch == null) {
                LoggingUtils.getEvoLogger().warn("Branch is null: " + branchId);
                continue;
            }
            info = new BranchInfo(branch.getClassName(), branch.getMethodName(), branch.getInstruction().getLineNumber(), true);
            branchCoverage.add(info);
        }
        this.testBranchCoverage.put(name, branchCoverage);
        this.uncoveredBranches.removeAll(branchCoverage);
        LinkedHashSet<MutationInfo> mutationCoverage = new LinkedHashSet<MutationInfo>();
        for (Assertion assertion : testCase.getAssertions()) {
            for (Mutation m : assertion.getKilledMutations()) {
                mutationCoverage.add(new MutationInfo(m));
            }
        }
        this.testMutantCoverage.put(name, mutationCoverage);
        this.uncoveredMutants.removeAll(mutationCoverage);
    }

    public void setTestSuiteCode(String code) {
        this.code = code;
    }

    public void setGeneticAlgorithm(GeneticAlgorithm<?> ga) {
        this.ga = ga;
        for (Map.Entry<FitnessFunction<?>, Double> e : ga.getBestIndividual().getCoverages().entrySet()) {
            this.targetCoverages.put(e.getKey(), e.getValue());
        }
    }
}

