/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.rmi;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.evosuite.rmi.UtilsRMI;
import org.evosuite.rmi.service.MasterNodeImpl;
import org.evosuite.rmi.service.MasterNodeLocal;
import org.evosuite.rmi.service.MasterNodeRemote;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterServices {
    private static Logger logger = LoggerFactory.getLogger(MasterServices.class);
    private static MasterServices instance = new MasterServices();
    private int registryPort = -1;
    private Registry registry;
    private MasterNodeImpl masterNode;

    protected MasterServices() {
    }

    public static MasterServices getInstance() {
        return instance;
    }

    public boolean startRegistry() throws IllegalStateException {
        if (this.registry != null) {
            throw new IllegalStateException("RMI registry is already running");
        }
        int port = 2000;
        port += Randomness.nextInt(20000);
        int TRIES = 100;
        for (int i = 0; i < 100; ++i) {
            try {
                int candidatePort = port + i;
                UtilsRMI.ensureRegistryOnLoopbackAddress();
                this.registry = LocateRegistry.createRegistry(candidatePort);
                this.registryPort = candidatePort;
                return true;
            }
            catch (RemoteException e) {
                continue;
            }
        }
        return false;
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    public void registerServices() throws RemoteException {
        this.masterNode = new MasterNodeImpl(this.registry);
        MasterNodeRemote stub = (MasterNodeRemote)UtilsRMI.exportObject(this.masterNode);
        this.registry.rebind("MasterNode", stub);
    }

    public MasterNodeLocal getMasterNode() {
        return this.masterNode;
    }

    public void stopServices() {
        if (this.masterNode != null) {
            try {
                UnicastRemoteObject.unexportObject(this.masterNode, true);
            }
            catch (NoSuchObjectException e) {
                logger.warn("Failed to delete MasterNode RMI instance", e);
            }
            this.masterNode = null;
        }
        if (this.registry != null) {
            try {
                UnicastRemoteObject.unexportObject(this.registry, true);
            }
            catch (NoSuchObjectException e) {
                logger.warn("Failed to stop RMI registry", e);
            }
            this.registry = null;
        }
    }
}

