/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import java.lang.instrument.UnmodifiableClassException;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.agent.InstrumentingAgent;
import org.evosuite.runtime.reset.ClassResetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassStateSupport {
    private static final Logger logger = LoggerFactory.getLogger(ClassStateSupport.class);

    public static void initializeClasses(ClassLoader classLoader, String ... classNames) {
        List<Class<?>> classes = ClassStateSupport.loadClasses(classLoader, classNames);
    }

    public static void resetClasses(String ... classNames) {
        for (int i = 0; i < classNames.length; ++i) {
            String classNameToReset = classNames[i];
            ClassResetter.getInstance().reset(classNameToReset);
        }
    }

    public static void retransformIfNeeded(ClassLoader classLoader, String ... classNames) {
        ArrayList classes = new ArrayList();
        for (String name : classNames) {
            try {
                classes.add(classLoader.loadClass(name));
            }
            catch (ClassNotFoundException e) {
                System.err.println("Could not load: " + name);
            }
        }
        ClassStateSupport.retransformIfNeeded(classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void retransformIfNeeded(List<Class<?>> classes) {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        ArrayList classToReInstument = new ArrayList();
        for (Class<?> cl : classes) {
            if (InstrumentingAgent.getTransformer().isClassAlreadyTransformed(cl.getName())) continue;
            classToReInstument.add(cl);
        }
        if (classToReInstument.isEmpty()) {
            return;
        }
        InstrumentingAgent.setRetransformingMode(true);
        try {
            if (!classToReInstument.isEmpty()) {
                InstrumentingAgent.getInstumentation().retransformClasses(classToReInstument.toArray(new Class[0]));
            }
        }
        catch (UnmodifiableClassException e) {
            System.err.println("Could not re-instrument classes");
        }
        catch (UnsupportedOperationException e) {
            logger.error("EvoSuite wrong re-instrumentation: " + e.getMessage());
        }
        finally {
            InstrumentingAgent.setRetransformingMode(false);
        }
        InstrumentingAgent.deactivate();
    }

    private static List<Class<?>> loadClasses(ClassLoader classLoader, String ... classNames) {
        ArrayList classes = new ArrayList();
        InstrumentingAgent.activate();
        for (int i = 0; i < classNames.length; ++i) {
            Runtime.getInstance().resetRuntime();
            String classNameToLoad = classNames[i];
            try {
                Class<?> aClass = Class.forName(classNameToLoad, true, classLoader);
                classes.add(aClass);
                continue;
            }
            catch (Error | Exception ex) {
                logger.error("Could not initialize " + classNameToLoad + ": " + ex.getMessage());
            }
        }
        InstrumentingAgent.deactivate();
        return classes;
    }
}

