/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.agent.InstrumentingAgent;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvoRunner
extends BlockJUnit4ClassRunner {
    private static final Logger logger = LoggerFactory.getLogger(EvoRunner.class);

    public EvoRunner(Class<?> klass) throws InitializationError {
        super(EvoRunner.getClass(klass));
    }

    private static Class<?> getClass(Class<?> klass) {
        EvoRunnerParameters ep = klass.getAnnotation(EvoRunnerParameters.class);
        if (ep == null) {
            throw new IllegalStateException("EvoSuite test class " + klass.getName() + " is not annotated with " + EvoRunnerParameters.class.getName());
        }
        RuntimeSettings.resetStaticState = ep.resetStaticState();
        RuntimeSettings.mockJVMNonDeterminism = ep.mockJVMNonDeterminism();
        RuntimeSettings.useVFS = ep.useVFS();
        InstrumentingAgent.initialize();
        InstrumentingAgent.activate();
        try {
            klass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("Failed to initialize test class " + klass.getName());
        }
        InstrumentingAgent.deactivate();
        return klass;
    }
}

