/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Field;
import javax.swing.JButton;

public class GuiSupport {
    private static final boolean isDefaultHeadless = GraphicsEnvironment.isHeadless();

    public static void setHeadless() {
        if (isDefaultHeadless) {
            return;
        }
        GuiSupport.setHeadless(true);
    }

    public static void initialize() {
        new JButton().getFontMetrics(new Font(null));
    }

    public static void restoreHeadlessMode() {
        if (GraphicsEnvironment.isHeadless() && !isDefaultHeadless) {
            GuiSupport.setHeadless(false);
        }
    }

    private static void setHeadless(boolean isHeadless) {
        System.setProperty("java.awt.headless", "" + isHeadless);
        try {
            Field headless = GraphicsEnvironment.class.getDeclaredField("headless");
            headless.setAccessible(true);
            headless.set(null, isHeadless);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("ERROR: failed to change AWT Headless state: " + e.getMessage(), e);
        }
    }
}

