/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.agent.InstrumentingAgent;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

public class InitializingListener
extends RunListener {
    public static final String INITIALIZE_CLASSES_METHOD = "initializeClasses";
    public static final String SCAFFOLDING_LIST_FILE_STRING = ".scaffolding_list.tmp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testRunStarted(Description description) throws Exception {
        System.out.println("Executing " + InitializingListener.class.getName());
        if (description != null) {
            System.out.println("WARN: Maven bug has now been fixed. Update EvoSuite");
            return;
        }
        RuntimeSettings.useVFS = true;
        RuntimeSettings.mockJVMNonDeterminism = true;
        RuntimeSettings.mockSystemIn = true;
        RuntimeSettings.resetStaticState = true;
        List<String> list = this.classesToInit();
        InstrumentingAgent.initialize();
        for (String name : list) {
            Method m = null;
            try {
                InstrumentingAgent.activate();
                Class<?> test = InitializingListener.class.getClassLoader().loadClass(name);
                m = test.getDeclaredMethod(INITIALIZE_CLASSES_METHOD, new Class[0]);
                m.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                System.out.println("Exception while loading class " + name + ": " + e.getMessage());
            }
            finally {
                InstrumentingAgent.deactivate();
            }
            if (m == null) continue;
            try {
                m.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                System.out.println("Exception while calling " + name + "." + INITIALIZE_CLASSES_METHOD + "(): " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> classesToInit() {
        ArrayList<String> list = new ArrayList<String>();
        File scaffolding = new File(SCAFFOLDING_LIST_FILE_STRING);
        if (!scaffolding.exists()) {
            System.out.println("WARN: scaffolding file not found. If this modules has tests, recall to use 'evosuite:prepare'");
            return list;
        }
        try (Scanner in = null;){
            in = new Scanner(scaffolding);
            while (in.hasNext()) {
                list.add(in.next().trim());
            }
        }
        return list;
    }
}

