/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import org.evosuite.runtime.Random;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.System;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.java.lang.MockThread;
import org.evosuite.runtime.thread.ThreadCounter;
import org.evosuite.runtime.vfs.VirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Runtime {
    private static final Logger logger = LoggerFactory.getLogger(Runtime.class);
    private static final Runtime singleton = new Runtime();

    protected Runtime() {
    }

    public static synchronized Runtime getInstance() {
        return singleton;
    }

    public static synchronized void resetSingleton() {
        singleton.resetRuntime();
    }

    public void resetRuntime() {
        MockFramework.enable();
        if (RuntimeSettings.mockJVMNonDeterminism) {
            Random.reset();
            System.resetRuntime();
            MockThread.reset();
            ThreadCounter.getInstance().resetSingleton();
        }
        if (RuntimeSettings.useVFS) {
            logger.debug("Resetting the VFS...");
            VirtualFileSystem.getInstance().resetSingleton();
            VirtualFileSystem.getInstance().init();
        }
    }
}

