/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.instrumentation;

import java.util.HashMap;
import org.evosuite.runtime.instrumentation.AnnotatedLabel;
import org.evosuite.runtime.instrumentation.MethodCallReplacementMethodAdapter;
import org.evosuite.runtime.mock.MockFramework;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class MethodCallReplacement {
    private final String className;
    private final String methodName;
    private final String desc;
    private final int origOpcode;
    private final String replacementClassName;
    private final String replacementMethodName;
    private final String replacementDesc;
    private final boolean popCallee;
    private final boolean popUninitialisedReference;

    public MethodCallReplacement(String className, String methodName, String desc, int opcode, String replacementClassName, String replacementMethodName, String replacementDesc, boolean pop, boolean pop2) {
        this.className = className;
        this.methodName = methodName;
        this.desc = desc;
        this.replacementClassName = replacementClassName;
        this.replacementMethodName = replacementMethodName;
        this.replacementDesc = replacementDesc;
        this.popCallee = pop;
        this.popUninitialisedReference = pop2;
        this.origOpcode = opcode;
    }

    public boolean isTarget(String owner, String name, String desc) {
        return this.className.equals(owner) && this.methodName.equals(name) && this.desc.equals(desc);
    }

    public void insertMethodCall(MethodCallReplacementMethodAdapter mv, int opcode) {
        mv.visitMethodInsn(184, MockFramework.class.getCanonicalName().replace('.', '/'), "isEnabled", "()Z", false);
        Label origCallLabel = new Label();
        Label afterOrigCallLabel = new Label();
        AnnotatedLabel annotationStartTag = new AnnotatedLabel(true, true);
        annotationStartTag.info = Boolean.TRUE;
        mv.visitLabel(annotationStartTag);
        mv.visitJumpInsn(153, origCallLabel);
        AnnotatedLabel annotationEndTag = new AnnotatedLabel(true, false);
        annotationEndTag.info = Boolean.FALSE;
        mv.visitLabel(annotationEndTag);
        if (this.popCallee) {
            int i;
            Type[] args = Type.getArgumentTypes(this.desc);
            HashMap<Integer, Integer> to = new HashMap<Integer, Integer>();
            for (i = args.length - 1; i >= 0; --i) {
                int loc = mv.newLocal(args[i]);
                mv.storeLocal(loc);
                to.put(i, loc);
            }
            mv.pop();
            if (this.popUninitialisedReference) {
                mv.pop();
            }
            for (i = 0; i < args.length; ++i) {
                mv.loadLocal((Integer)to.get(i));
            }
        }
        mv.visitMethodInsn(opcode, this.replacementClassName, this.replacementMethodName, this.replacementDesc, false);
        mv.visitJumpInsn(167, afterOrigCallLabel);
        mv.visitLabel(origCallLabel);
        mv.getNextVisitor().visitMethodInsn(this.origOpcode, this.className, this.methodName, this.desc, false);
        mv.visitLabel(afterOrigCallLabel);
    }

    public void insertConstructorCall(MethodCallReplacementMethodAdapter mv, MethodCallReplacement replacement, boolean isSelf) {
        Label origCallLabel = new Label();
        Label afterOrigCallLabel = new Label();
        if (!isSelf) {
            int i;
            mv.visitMethodInsn(184, MockFramework.class.getCanonicalName().replace('.', '/'), "isEnabled", "()Z", false);
            AnnotatedLabel annotationStartTag = new AnnotatedLabel(true, true);
            annotationStartTag.info = Boolean.TRUE;
            mv.visitLabel(annotationStartTag);
            mv.visitJumpInsn(153, origCallLabel);
            AnnotatedLabel annotationEndTag = new AnnotatedLabel(true, false);
            annotationEndTag.info = Boolean.FALSE;
            mv.visitLabel(annotationEndTag);
            Type[] args = Type.getArgumentTypes(this.desc);
            HashMap<Integer, Integer> to = new HashMap<Integer, Integer>();
            for (i = args.length - 1; i >= 0; --i) {
                int loc = mv.newLocal(args[i]);
                mv.storeLocal(loc);
                to.put(i, loc);
            }
            mv.pop2();
            mv.newInstance(Type.getType(replacement.replacementClassName));
            mv.dup();
            for (i = 0; i < args.length; ++i) {
                mv.loadLocal((Integer)to.get(i));
            }
        }
        mv.visitMethodInsn(183, this.replacementClassName, this.replacementMethodName, this.replacementDesc, false);
        if (!isSelf) {
            mv.visitJumpInsn(167, afterOrigCallLabel);
            mv.visitLabel(origCallLabel);
            mv.getNextVisitor().visitMethodInsn(183, this.className, this.methodName, this.desc, false);
            mv.visitLabel(afterOrigCallLabel);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodNameWithDesc() {
        return this.methodName + this.desc;
    }
}

