/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.instrumentation;

import java.util.List;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class RemoveFinalMethodAdapter
extends MethodVisitor {
    private final List<String> finalFields;
    private final String className;

    public RemoveFinalMethodAdapter(String className, MethodVisitor mv, List<String> finalFields) {
        super(327680, mv);
        this.finalFields = finalFields;
        this.className = className;
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if ((opcode == 181 || opcode == 179) && owner.equals(this.className)) {
            if (!this.finalFields.contains(name)) {
                super.visitFieldInsn(opcode, owner, name, desc);
            } else {
                Type type = Type.getType(desc);
                if (type.getSize() == 1) {
                    super.visitInsn(87);
                } else if (type.getSize() == 2) {
                    super.visitInsn(88);
                }
                if (opcode == 181) {
                    super.visitInsn(87);
                }
            }
        } else {
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }
}

