/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.lang;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.java.lang.MockException;
import org.evosuite.runtime.mock.java.lang.MockThrowable;
import org.evosuite.runtime.thread.ThreadCounter;

public class MockThread
extends Thread
implements OverrideMock {
    private static final Map<Integer, Long> threadMap = new ConcurrentHashMap<Integer, Long>();
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;

    public static void reset() {
        threadMap.clear();
    }

    public static Thread currentThread() {
        return Thread.currentThread();
    }

    public static void yield() {
        Thread.yield();
    }

    public static void sleep(long millis) throws InterruptedException {
        Thread.sleep(millis);
    }

    public static void sleep(long millis, int nanos) throws InterruptedException {
        Thread.sleep(millis, nanos);
    }

    public static boolean interrupted() {
        return Thread.interrupted();
    }

    public static int activeCount() {
        return Thread.activeCount();
    }

    public static int enumerate(Thread[] tarray) {
        return Thread.enumerate(tarray);
    }

    public static void dumpStack() {
        if (!MockFramework.isEnabled()) {
            Thread.dumpStack();
        } else {
            new MockException("Stack trace").printStackTrace();
        }
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        if (!MockFramework.isEnabled()) {
            return Thread.getAllStackTraces();
        }
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        HashMap<Thread, StackTraceElement[]> m = new HashMap<Thread, StackTraceElement[]>(threads.size());
        for (Thread t : threads) {
            m.put(t, MockThrowable.getDefaultStackTrace());
        }
        return m;
    }

    public static boolean holdsLock(Object obj) {
        return Thread.holdsLock(obj);
    }

    public static void setDefaultUncaughtExceptionHandler(Thread.UncaughtExceptionHandler eh) {
        Thread.setDefaultUncaughtExceptionHandler(eh);
    }

    public static Thread.UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return Thread.getDefaultUncaughtExceptionHandler();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public MockThread() {
        this.mockSetup(null);
    }

    public MockThread(Runnable target) {
        super(target);
        this.mockSetup(null);
    }

    public MockThread(ThreadGroup group, Runnable target) {
        super(group, target);
        this.mockSetup(null);
    }

    public MockThread(String name) {
        super(name);
        this.mockSetup(name);
    }

    public MockThread(ThreadGroup group, String name) {
        super(group, name);
        this.mockSetup(name);
    }

    public MockThread(Runnable target, String name) {
        super(target, name);
        this.mockSetup(name);
    }

    public MockThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
        this.mockSetup(name);
    }

    public MockThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
        this.mockSetup(name);
    }

    private void mockSetup(String name) {
        if (!MockFramework.isEnabled()) {
            return;
        }
        if (name == null) {
            this.setName("Thread-" + this.getId());
        }
    }

    @Override
    public synchronized void start() {
        if (MockFramework.isEnabled()) {
            ThreadCounter.getInstance().checkIfCanStartNewThread();
        }
        super.start();
    }

    @Override
    public void run() {
        super.run();
    }

    @Override
    public void interrupt() {
        super.interrupt();
    }

    @Override
    public boolean isInterrupted() {
        return super.isInterrupted();
    }

    public void destroy() {
        super.destroy();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return super.getContextClassLoader();
    }

    @Override
    public void setContextClassLoader(ClassLoader cl) {
        super.setContextClassLoader(cl);
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        if (!MockFramework.isEnabled()) {
            return super.getStackTrace();
        }
        return MockThrowable.getDefaultStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getId() {
        if (!MockFramework.isEnabled()) {
            return super.getId();
        }
        Map<Integer, Long> map = threadMap;
        synchronized (map) {
            int identity = System.identityHashCode(this);
            if (!threadMap.containsKey(identity)) {
                threadMap.put(identity, Long.valueOf(threadMap.size()));
            }
            return threadMap.get(identity);
        }
    }

    @Override
    public Thread.State getState() {
        return super.getState();
    }

    @Override
    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return super.getUncaughtExceptionHandler();
    }

    @Override
    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler eh) {
        super.setUncaughtExceptionHandler(eh);
    }
}

