/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.evosuite.runtime.mock.StaticReplacementMock;
import org.evosuite.runtime.mock.java.net.Inet4AddressUtil;
import org.evosuite.runtime.vnet.EvoIPAddressUtil;
import org.evosuite.runtime.vnet.NetworkInterfaceState;
import org.evosuite.runtime.vnet.VirtualNetwork;

public class MockInetAddress
implements StaticReplacementMock {
    @Override
    public String getMockedClassName() {
        return InetAddress.class.getName();
    }

    public static boolean isMulticastAddress(InetAddress addr) {
        return addr.isMulticastAddress();
    }

    public static boolean isAnyLocalAddress(InetAddress addr) {
        return addr.isAnyLocalAddress();
    }

    public static boolean isLoopbackAddress(InetAddress addr) {
        return addr.isLoopbackAddress();
    }

    public static boolean isLinkLocalAddress(InetAddress addr) {
        return addr.isLinkLocalAddress();
    }

    public static boolean isSiteLocalAddress(InetAddress addr) {
        return addr.isSiteLocalAddress();
    }

    public static boolean isMCGlobal(InetAddress addr) {
        return addr.isMCGlobal();
    }

    public static boolean isMCNodeLocal(InetAddress addr) {
        return addr.isMCNodeLocal();
    }

    public static boolean isMCLinkLocal(InetAddress addr) {
        return addr.isMCLinkLocal();
    }

    public static boolean isMCSiteLocal(InetAddress addr) {
        return addr.isMCSiteLocal();
    }

    public static boolean isMCOrgLocal(InetAddress addr) {
        return addr.isMCOrgLocal();
    }

    public static byte[] getAddress(InetAddress addr) {
        return addr.getAddress();
    }

    public static String getHostAddress(InetAddress addr) {
        return addr.getHostAddress();
    }

    public static int hashCode(InetAddress addr) {
        return addr.hashCode();
    }

    public static boolean equals(InetAddress addr, Object obj) {
        return addr.equals(obj);
    }

    public static String toString(InetAddress addr) {
        return addr.toString();
    }

    public static boolean isReachable(InetAddress addr, int timeout) throws IOException {
        return MockInetAddress.isReachable(addr, null, 0, timeout);
    }

    public static boolean isReachable(InetAddress addr, NetworkInterface netif, int ttl, int timeout) throws IOException {
        if (ttl < 0) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        return true;
    }

    public static String getHostName(InetAddress addr) {
        return addr.getHostAddress();
    }

    public static String getCanonicalHostName(InetAddress addr) {
        return MockInetAddress.getHostName(addr);
    }

    public static InetAddress getByAddress(byte[] addr) throws UnknownHostException {
        return MockInetAddress.getByAddress(null, addr);
    }

    public static InetAddress getByAddress(String host, byte[] addr) throws UnknownHostException {
        if (host != null && host.length() > 0 && host.charAt(0) == '[' && host.charAt(host.length() - 1) == ']') {
            host = host.substring(1, host.length() - 1);
        }
        if (addr != null && addr.length == 4) {
            return Inet4AddressUtil.createNewInstance(host, addr);
        }
        throw new UnknownHostException("Not IPv4: " + Arrays.toString(addr));
    }

    public static InetAddress getByName(String host) throws UnknownHostException {
        return MockInetAddress.getAllByName(host)[0];
    }

    public static InetAddress[] getAllByName(String host) throws UnknownHostException {
        byte[] addr;
        if (host == null || host.length() == 0) {
            InetAddress[] ret = new InetAddress[]{MockInetAddress.getLoopbackAddress()};
            return ret;
        }
        if (Character.digit(host.charAt(0), 16) != -1 && (addr = EvoIPAddressUtil.textToNumericFormatV4(host)) != null && addr.length == 4) {
            InetAddress[] ret = new InetAddress[]{Inet4AddressUtil.createNewInstance(null, addr)};
            return ret;
        }
        String resolved = VirtualNetwork.getInstance().dnsResolve(host);
        if (resolved == null) {
            throw new UnknownHostException("Cannot resolve: " + resolved);
        }
        byte[] addr2 = EvoIPAddressUtil.textToNumericFormatV4(resolved);
        InetAddress[] ret = new InetAddress[]{Inet4AddressUtil.createNewInstance(host, addr2)};
        return ret;
    }

    public static InetAddress getLoopbackAddress() {
        List<NetworkInterfaceState> list = VirtualNetwork.getInstance().getAllNetworkInterfaceStates();
        for (NetworkInterfaceState nis : list) {
            List<InetAddress> addresses;
            if (!nis.isLoopback() || (addresses = nis.getLocalAddresses()) == null || addresses.isEmpty()) continue;
            return addresses.get(0);
        }
        return null;
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        return MockInetAddress.getLoopbackAddress();
    }

    public static InetAddress anyLocalAddress() {
        try {
            return MockInetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

