/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.java.net.MockInetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockInetSocketAddress
extends InetSocketAddress
implements OverrideMock {
    private static final Logger logger = LoggerFactory.getLogger(MockInetSocketAddress.class);
    private static final long serialVersionUID = 5076001401234631237L;

    private static String checkHost(String hostname) {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname can't be null");
        }
        return hostname;
    }

    public MockInetSocketAddress(int port) {
        this(MockInetAddress.anyLocalAddress(), port);
    }

    public MockInetSocketAddress(InetAddress addr, int port) {
        super(addr == null ? MockInetAddress.anyLocalAddress() : addr, port);
    }

    private static InetAddress getResolvedAddressed(String hostname) {
        MockInetSocketAddress.checkHost(hostname);
        try {
            return InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            logger.warn("EvoSuite limitation: unsupported case of hostname resolution for " + hostname);
            return null;
        }
    }

    public MockInetSocketAddress(String hostname, int port) {
        this(MockInetSocketAddress.getResolvedAddressed(hostname), port);
    }

    public static InetSocketAddress createUnresolved(String host, int port) {
        return InetSocketAddress.createUnresolved(host, port);
    }
}

