/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.evosuite.runtime.mock.StaticReplacementMock;
import org.evosuite.runtime.vnet.NetworkInterfaceState;
import org.evosuite.runtime.vnet.VirtualNetwork;

public class MockNetworkInterface
implements StaticReplacementMock {
    @Override
    public String getMockedClassName() {
        return NetworkInterface.class.getName();
    }

    public static Enumeration<InetAddress> getInetAddresses(NetworkInterface ni) {
        class Enumuerator
        implements Enumeration<InetAddress> {
            private int i = 0;
            private List<InetAddress> local_addrs = VirtualNetwork.getInstance().getNetworkInterfaceState(this.val$ni.getName()).getLocalAddresses();
            final /* synthetic */ NetworkInterface val$ni;

            Enumuerator(NetworkInterface networkInterface) {
                this.val$ni = networkInterface;
            }

            @Override
            public InetAddress nextElement() {
                if (this.i < this.local_addrs.size()) {
                    return this.local_addrs.get(this.i++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i < this.local_addrs.size();
            }
        }
        return new Enumuerator(ni);
    }

    public static List<InterfaceAddress> getInterfaceAddresses(NetworkInterface ni) {
        throw new RuntimeException("Not supported method by EvoSuite");
    }

    public static Enumeration<NetworkInterface> getSubInterfaces(NetworkInterface ni) {
        class SubIFs
        implements Enumeration<NetworkInterface> {
            SubIFs() {
            }

            @Override
            public NetworkInterface nextElement() {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return false;
            }
        }
        return new SubIFs();
    }

    public static int getIndex(NetworkInterface ni) {
        return ni.getIndex();
    }

    public static String getName(NetworkInterface ni) {
        return ni.getName();
    }

    public static String getDisplayName(NetworkInterface ni) {
        return ni.getName();
    }

    public static boolean isUp(NetworkInterface ni) throws SocketException {
        return VirtualNetwork.getInstance().getNetworkInterfaceState(ni.getName()).isUp();
    }

    public static NetworkInterface getParent(NetworkInterface ni) {
        return VirtualNetwork.getInstance().getNetworkInterfaceState(ni.getName()).getParent();
    }

    public boolean isLoopback(NetworkInterface ni) throws SocketException {
        return VirtualNetwork.getInstance().getNetworkInterfaceState(ni.getName()).isLoopback();
    }

    public boolean isPointToPoint(NetworkInterface ni) throws SocketException {
        return VirtualNetwork.getInstance().getNetworkInterfaceState(ni.getName()).isPointToPoint();
    }

    public boolean supportsMulticast(NetworkInterface ni) throws SocketException {
        return VirtualNetwork.getInstance().getNetworkInterfaceState(ni.getName()).supportsMulticast();
    }

    public byte[] getHardwareAddress(NetworkInterface ni) throws SocketException {
        return VirtualNetwork.getInstance().getNetworkInterfaceState(ni.getName()).getMacAddr();
    }

    public int getMTU(NetworkInterface ni) throws SocketException {
        return VirtualNetwork.getInstance().getNetworkInterfaceState(ni.getName()).getMTU();
    }

    public static boolean isVirtual(NetworkInterface ni) {
        return VirtualNetwork.getInstance().getNetworkInterfaceState(ni.getName()).isVirtual();
    }

    public static NetworkInterface getByName(String name) throws SocketException {
        if (name == null) {
            throw new NullPointerException();
        }
        NetworkInterfaceState state = VirtualNetwork.getInstance().getNetworkInterfaceState(name);
        if (state == null) {
            return null;
        }
        return state.getNetworkInterface();
    }

    public static NetworkInterface getByIndex(int index) throws SocketException {
        if (index < 0) {
            throw new IllegalArgumentException("Interface index can't be negative");
        }
        for (NetworkInterfaceState nis : VirtualNetwork.getInstance().getAllNetworkInterfaceStates()) {
            if (nis.getNetworkInterface().getIndex() != index) continue;
            return nis.getNetworkInterface();
        }
        return null;
    }

    public static NetworkInterface getByInetAddress(InetAddress addr) throws SocketException {
        if (addr == null) {
            throw new NullPointerException();
        }
        if (!(addr instanceof Inet4Address) && !(addr instanceof Inet6Address)) {
            throw new IllegalArgumentException("invalid address type");
        }
        for (NetworkInterfaceState nis : VirtualNetwork.getInstance().getAllNetworkInterfaceStates()) {
            if (!nis.getLocalAddresses().contains(addr)) continue;
            return nis.getNetworkInterface();
        }
        return null;
    }

    public static Enumeration<NetworkInterface> getNetworkInterfaces() throws SocketException {
        final List<NetworkInterfaceState> netifs = VirtualNetwork.getInstance().getAllNetworkInterfaceStates();
        if (netifs == null || netifs.isEmpty()) {
            return null;
        }
        return new Enumeration<NetworkInterface>(){
            private int i = 0;

            @Override
            public NetworkInterface nextElement() {
                if (netifs != null && this.i < netifs.size()) {
                    NetworkInterface netif = ((NetworkInterfaceState)netifs.get(this.i)).getNetworkInterface();
                    ++this.i;
                    return netif;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return netifs != null && this.i < netifs.size();
            }
        };
    }

    public static boolean equals(NetworkInterface ni, Object obj) {
        return ni.equals(obj);
    }

    public static int hashCode(NetworkInterface ni) {
        return ni.hashCode();
    }

    public static String toString(NetworkInterface ni) {
        return ni.toString();
    }
}

