/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.runtime.mock.StaticReplacementMock;
import org.evosuite.runtime.mock.java.net.EvoURLStreamHandler;
import org.evosuite.runtime.mock.java.net.URLStreamHandlerUtil;
import org.evosuite.runtime.mock.java.net.URLUtil;

public class MockURL
implements StaticReplacementMock {
    private static URLStreamHandlerFactory factory;
    private static Map<String, URLStreamHandler> handlers;
    private static final Object streamHandlerLock;

    @Override
    public String getMockedClassName() {
        return URL.class.getName();
    }

    public static void initStaticState() {
        factory = null;
        handlers.clear();
    }

    public static URL URL(String spec) throws MalformedURLException {
        return MockURL.URL(null, spec);
    }

    public static URL URL(URL context, String spec) throws MalformedURLException {
        return MockURL.URL(context, spec, null);
    }

    public static URL URL(String protocol, String host, String file) throws MalformedURLException {
        return MockURL.URL(protocol, host, -1, file);
    }

    public static URL URL(String protocol, String host, int port, String file) throws MalformedURLException {
        return MockURL.URL(protocol, host, port, file, null);
    }

    public static URL URL(String protocol, String host, int port, String file, URLStreamHandler handler) throws MalformedURLException {
        URL url = new URL(protocol, host, port, file, handler);
        if (handler == null) {
            handler = MockURL.getMockedURLStreamHandler(protocol);
            URLUtil.setHandler(url, handler);
        }
        return url;
    }

    public static URL URL(URL context, String spec, URLStreamHandler handler) throws MalformedURLException {
        URL url = new URL(context, spec, handler);
        if (handler == null) {
            handler = MockURL.getMockedURLStreamHandler(url.getProtocol());
            URLUtil.setHandler(url, handler);
            MockURL.handleParseUrl(url, spec, handler);
        }
        return url;
    }

    private static void handleParseUrl(URL url, String spec, URLStreamHandler handler) {
        char c;
        int i;
        int limit;
        int start = 0;
        boolean aRef = false;
        for (limit = spec.length(); limit > 0 && spec.charAt(limit - 1) <= ' '; --limit) {
        }
        while (start < limit && spec.charAt(start) <= ' ') {
            ++start;
        }
        if (spec.regionMatches(true, start, "url:", 0, 4)) {
            start += 4;
        }
        if (start < spec.length() && spec.charAt(start) == '#') {
            aRef = true;
        }
        for (i = start; !aRef && i < limit && (c = spec.charAt(i)) != '/'; ++i) {
            if (c != ':') continue;
            String s = spec.substring(start, i).toLowerCase();
            if (!MockURL.isValidProtocol(s)) break;
            start = i + 1;
            break;
        }
        if ((i = spec.indexOf(35, start)) >= 0) {
            limit = i;
        }
        URLStreamHandlerUtil.parseURL(handler, url, spec, start, limit);
    }

    private static boolean isValidProtocol(String protocol) {
        int len = protocol.length();
        if (len < 1) {
            return false;
        }
        char c = protocol.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            c = protocol.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') continue;
            return false;
        }
        return true;
    }

    public static String getQuery(URL url) {
        return url.getQuery();
    }

    public static String getPath(URL url) {
        return url.getPath();
    }

    public static String getUserInfo(URL url) {
        return url.getUserInfo();
    }

    public static String getAuthority(URL url) {
        return url.getAuthority();
    }

    public static int getPort(URL url) {
        return url.getPort();
    }

    public static int getDefaultPort(URL url) {
        return url.getDefaultPort();
    }

    public static String getProtocol(URL url) {
        return url.getProtocol();
    }

    public static String getHost(URL url) {
        return url.getHost();
    }

    public static String getFile(URL url) {
        return url.getFile();
    }

    public static String getRef(URL url) {
        return url.getRef();
    }

    public static boolean equals(URL url, Object obj) {
        return url.equals(obj);
    }

    public static synchronized int hashCode(URL url) {
        return url.hashCode();
    }

    public static boolean sameFile(URL url, URL other) {
        return url.sameFile(other);
    }

    public static String toString(URL url) {
        return url.toString();
    }

    public static String toExternalForm(URL url) {
        return url.toExternalForm();
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return new URI(url.toString());
    }

    public static URLConnection openConnection(URL url) throws IOException {
        return url.openConnection();
    }

    public static URLConnection openConnection(URL url, Proxy proxy) throws IOException {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy can not be null");
        }
        return URLStreamHandlerUtil.openConnection(URLUtil.getHandler(url), url, proxy);
    }

    public static InputStream openStream(URL url) throws IOException {
        return url.openStream();
    }

    public static Object getContent(URL url) throws IOException {
        return url.getContent();
    }

    public static Object getContent(URL url, Class[] classes) throws IOException {
        return url.getContent(classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setURLStreamHandlerFactory(URLStreamHandlerFactory fac) {
        Object object = streamHandlerLock;
        synchronized (object) {
            if (factory != null) {
                throw new Error("factory already defined");
            }
            handlers.clear();
            factory = fac;
        }
    }

    protected static URLStreamHandler getMockedURLStreamHandler(String protocol) throws MalformedURLException {
        URLStreamHandler handler = handlers.get(protocol);
        if (handler == null) {
            if (factory != null) {
                handler = factory.createURLStreamHandler(protocol);
            }
            if (handler == null) {
                if (EvoURLStreamHandler.isValidProtocol(protocol)) {
                    handler = new EvoURLStreamHandler(protocol);
                } else {
                    throw new MalformedURLException("unknown protocol: " + protocol);
                }
            }
            handlers.put(protocol, handler);
        }
        return handler;
    }

    static {
        handlers = new ConcurrentHashMap<String, URLStreamHandler>();
        streamHandlerLock = new Object();
    }
}

