/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.io.IOException;
import java.io.OutputStream;
import org.evosuite.runtime.vnet.NativeTcp;

public class SocketOut
extends OutputStream {
    private final NativeTcp tcp;
    private final boolean isLocal;
    private volatile boolean closed;

    public SocketOut(NativeTcp tcp, boolean isLocal) {
        this.tcp = tcp;
        this.isLocal = isLocal;
        this.closed = false;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        if (this.isLocal) {
            this.tcp.writeToRemote((byte)b);
        } else {
            this.tcp.writeToSUT((byte)b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Closed stream");
        }
    }
}

