/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.reset;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassResetter {
    private static Logger logger = LoggerFactory.getLogger(ClassResetter.class);
    public static final String STATIC_RESET = "__STATIC_RESET";
    private static final ClassResetter instance = new ClassResetter();
    private ClassLoader loader;
    private Map<ClassLoader, Map<String, Method>> resetMethodCache = new HashMap<ClassLoader, Map<String, Method>>();

    public static ClassResetter getInstance() {
        return instance;
    }

    public void setClassLoader(ClassLoader loader) throws IllegalArgumentException {
        if (loader == null) {
            throw new IllegalArgumentException("Null class loader");
        }
        this.loader = loader;
    }

    private void cacheResetMethod(String classNameWithDots) {
        Map<String, Method> methodMap;
        if (!this.resetMethodCache.containsKey(this.loader)) {
            this.resetMethodCache.put(this.loader, new HashMap());
        }
        if ((methodMap = this.resetMethodCache.get(this.loader)).containsKey(classNameWithDots)) {
            return;
        }
        try {
            Class<?> clazz = this.loader.loadClass(classNameWithDots);
            if (clazz.isInterface() || clazz.isAnonymousClass()) {
                return;
            }
            Method m = clazz.getDeclaredMethod(STATIC_RESET, null);
            m.setAccessible(true);
            methodMap.put(classNameWithDots, m);
        }
        catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            logger.error("" + e, e);
        }
    }

    private Method getResetMethod(String classNameWithDots) {
        this.cacheResetMethod(classNameWithDots);
        return this.resetMethodCache.get(this.loader).get(classNameWithDots);
    }

    public void reset(String classNameWithDots) throws IllegalArgumentException, IllegalStateException {
        if (classNameWithDots == null || classNameWithDots.isEmpty()) {
            throw new IllegalArgumentException("Empty class name in input");
        }
        if (this.loader == null) {
            throw new IllegalStateException("No specified loader");
        }
        Method m = this.getResetMethod(classNameWithDots);
        if (m == null) {
            return;
        }
        try {
            m.invoke(null, (Object[])null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoClassDefFoundError | InvocationTargetException e) {
            logger.error("" + e, e);
        }
    }
}

