/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.reset;

import java.util.LinkedList;
import java.util.List;

public class ResetManager {
    private static ResetManager instance;
    private boolean resetAllClasses = false;
    private boolean tracingIsEnabled = true;
    private final List<String> classInitializationOrder = new LinkedList<String>();
    private boolean resetFinalFields = false;

    public static synchronized ResetManager getInstance() {
        if (instance == null) {
            instance = new ResetManager();
        }
        return instance;
    }

    public void clearManager() {
        this.resetAllClasses = false;
        this.tracingIsEnabled = true;
        this.classInitializationOrder.clear();
        this.resetFinalFields = false;
    }

    private ResetManager() {
    }

    public boolean isTracingEnabled() {
        return this.tracingIsEnabled;
    }

    public void enableTracing() {
        this.tracingIsEnabled = true;
    }

    public void disableTracing() {
        this.tracingIsEnabled = false;
    }

    public static void exitClassInit(String className) {
        String classNameWithDots = className.replace("/", ".");
        ResetManager classInitOrder = ResetManager.getInstance();
        if (classInitOrder.isTracingEnabled()) {
            classInitOrder.addClassInitialization(classNameWithDots);
        }
    }

    private void addClassInitialization(String classNameWithDots) {
        if (!this.classInitializationOrder.contains(classNameWithDots)) {
            this.classInitializationOrder.add(classNameWithDots);
        }
    }

    public boolean getResetAllClasses() {
        return this.resetAllClasses;
    }

    public List<String> getClassResetOrder() {
        return this.classInitializationOrder;
    }

    public void setResetAllClasses(boolean b) {
        this.resetAllClasses = b;
    }

    public void setResetFinalFields(boolean b) {
        this.resetFinalFields = b;
    }

    public boolean getResetFinalFields() {
        return this.resetFinalFields;
    }
}

