/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.sandbox;

import java.awt.AWTPermission;
import java.io.File;
import java.io.FilePermission;
import java.io.SerializablePermission;
import java.lang.management.ManagementPermission;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.security.AccessControlContext;
import java.security.AllPermission;
import java.security.Permission;
import java.security.SecurityPermission;
import java.security.UnresolvedPermission;
import java.sql.SQLPermission;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.LoggingPermission;
import javax.management.MBeanPermission;
import javax.management.MBeanServerPermission;
import javax.management.MBeanTrustPermission;
import javax.management.remote.SubjectDelegationPermission;
import javax.net.ssl.SSLPermission;
import javax.security.auth.AuthPermission;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.kerberos.DelegationPermission;
import javax.security.auth.kerberos.ServicePermission;
import javax.sound.sampled.AudioPermission;
import javax.xml.ws.WebServicePermission;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.System;
import org.evosuite.runtime.sandbox.PermissionStatistics;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.runtime.vfs.VirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSecurityManager
extends SecurityManager {
    private static Logger logger = LoggerFactory.getLogger(MSecurityManager.class);
    private static final String USER_DIR = java.lang.System.getProperty("user.home");
    private static final String JAVA_VERSION = java.lang.System.getProperty("java.version");
    private static final String AWT_HEADLESS = java.lang.System.getProperty("java.awt.headless");
    private static final File tmpFile;
    public static final String FILE_HANDLER_NAME_PATTERN = ".tmp_file_needed_by_mock_of_FileHandler";
    private final Set<File> filesToDelete;
    private final PermissionStatistics statistics = PermissionStatistics.getInstance();
    private final SecurityManager defaultManager;
    private volatile boolean executingTestCase;
    private volatile Set<Thread> privilegedThreads = new CopyOnWriteArraySet<Thread>();
    private volatile Thread privilegedThreadToIgnore;
    private static Set<String> masterNodeRemoteMethodNames;
    private static boolean runningClientOnThread;
    private final Set<Permission> unrecognizedPermissions;

    public MSecurityManager() {
        this.privilegedThreads.add(Thread.currentThread());
        this.defaultManager = java.lang.System.getSecurityManager();
        this.executingTestCase = false;
        this.privilegedThreadToIgnore = null;
        this.unrecognizedPermissions = new CopyOnWriteArraySet<Permission>();
        this.filesToDelete = new CopyOnWriteArraySet<File>();
    }

    public static void setupMasterNodeRemoteHandling(Class<?> remoteNode) {
        Method[] methods = remoteNode.getMethods();
        HashSet<String> names = new HashSet<String>();
        for (Method m : methods) {
            names.add(m.getName());
        }
        masterNodeRemoteMethodNames = Collections.unmodifiableSet(names);
    }

    public Set<Thread> getPriviledThreads() {
        LinkedHashSet<Thread> set = new LinkedHashSet<Thread>();
        set.addAll(this.privilegedThreads);
        return set;
    }

    public static void setRunningClientOnThread(boolean runningClientOnThread) {
        MSecurityManager.runningClientOnThread = runningClientOnThread;
    }

    public static File getRealTmpFile() {
        return tmpFile;
    }

    public void goingToExecuteUnsafeCodeOnSameThread() throws SecurityException, IllegalStateException {
        if (!this.privilegedThreads.contains(Thread.currentThread())) {
            throw new SecurityException("Current thread is not privileged");
        }
        if (this.privilegedThreadToIgnore != null) {
            throw new IllegalStateException("The thread is already executing unsafe code");
        }
        this.privilegedThreadToIgnore = Thread.currentThread();
    }

    public boolean isSafeToExecuteSUTCode() {
        Thread current = Thread.currentThread();
        if (!this.privilegedThreads.contains(current)) {
            return true;
        }
        return this.privilegedThreadToIgnore == current;
    }

    public void doneWithExecutingUnsafeCodeOnSameThread() throws SecurityException, IllegalStateException {
        if (!this.privilegedThreads.contains(Thread.currentThread())) {
            throw new SecurityException("Only a privileged thread can return from unsafe code execution");
        }
        if (this.privilegedThreadToIgnore == null) {
            throw new IllegalStateException("The thread was not executing unsafe code");
        }
        this.privilegedThreadToIgnore = null;
    }

    public void makePriviligedAllCurrentThreads() {
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        Thread[] threads = new Thread[root.activeCount() + 10];
        root.enumerate(threads);
        for (Thread t : threads) {
            if (t == null) continue;
            this.addPrivilegedThread(t);
        }
    }

    public void apply() throws IllegalStateException {
        try {
            java.lang.System.setSecurityManager(this);
        }
        catch (SecurityException e) {
            logger.error("Cannot instantiate mock security manager", e);
            throw new IllegalStateException(e);
        }
    }

    public void restoreDefaultManager() throws SecurityException {
        java.lang.System.setSecurityManager(this.defaultManager);
    }

    public void goingToExecuteTestCase() throws IllegalStateException {
        if (this.executingTestCase) {
            throw new IllegalStateException("Trying to set up the sandbox while executing a test case");
        }
        this.executingTestCase = true;
    }

    public void goingToEndTestCase() throws IllegalStateException {
        if (!this.executingTestCase) {
            throw new IllegalStateException("Trying to disable sandbox when not test case was run");
        }
        System.restoreProperties();
        for (File file : this.filesToDelete) {
            file.deleteOnExit();
        }
        this.executingTestCase = false;
    }

    public void addPrivilegedThread(Thread t) throws SecurityException {
        if (!this.privilegedThreads.contains(Thread.currentThread())) {
            throw new SecurityException("Unprivileged thread cannot add a privileged thread");
        }
        logger.debug("Adding privileged thread: " + t.getName());
        this.privilegedThreads.add(t);
    }

    @Override
    public void checkPermission(Permission perm, Object context) throws SecurityException, NullPointerException {
        if (!(context instanceof AccessControlContext)) {
            throw new SecurityException();
        }
        this.checkPermission(perm);
    }

    @Override
    public void checkPermission(Permission perm) throws SecurityException {
        if (!this.allowPermission(perm)) {
            if (this.executingTestCase) {
                this.statistics.permissionDenied(perm);
            }
            String stack = "\n";
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                stack = stack + e + "\n";
            }
            logger.debug("Security manager blocks permission " + perm + stack);
            throw new SecurityException("Security manager blocks " + perm + stack);
        }
        if (this.executingTestCase) {
            this.statistics.permissionAllowed(perm);
        }
    }

    private boolean isAWTThread() {
        for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
            if (e.getClassName().startsWith("java.awt")) {
                return true;
            }
            if (e.getClassName().startsWith("javax.swing")) {
                return true;
            }
            if (!e.getClassName().startsWith("java.util.logging.LogManager")) continue;
            return true;
        }
        return false;
    }

    private boolean allowPermission(Permission perm) {
        if (RuntimeSettings.sandboxMode.equals((Object)Sandbox.SandboxMode.OFF)) {
            return true;
        }
        if (perm instanceof RuntimePermission && "getStackTrace".equals(perm.getName().trim())) {
            return true;
        }
        if (this.checkIfEvoSuiteRMI(perm) || this.checkIfRMIDuringTests(perm)) {
            return true;
        }
        if (this.privilegedThreads.contains(Thread.currentThread()) && (this.privilegedThreadToIgnore == null || !this.privilegedThreadToIgnore.equals(Thread.currentThread()))) {
            if (this.defaultManager == null) {
                return true;
            }
            try {
                this.defaultManager.checkPermission(perm);
            }
            catch (SecurityException e) {
                return false;
            }
            return true;
        }
        if (RuntimeSettings.sandboxMode.equals((Object)Sandbox.SandboxMode.IO)) {
            PermissionStatistics.getInstance().countThreads(Thread.currentThread().getThreadGroup().activeCount());
            if (perm instanceof FilePermission) {
                return this.checkFilePermission((FilePermission)perm);
            }
            return true;
        }
        PermissionStatistics.getInstance().countThreads(Thread.currentThread().getThreadGroup().activeCount());
        if (perm instanceof FilePermission) {
            return this.checkFilePermission((FilePermission)perm);
        }
        if (perm instanceof AllPermission) {
            return this.checkAllPermission((AllPermission)perm);
        }
        if (perm instanceof SecurityPermission) {
            return this.checkSecurityPermission((SecurityPermission)perm);
        }
        if (perm instanceof LoggingPermission) {
            return this.checkLoggingPermission((LoggingPermission)perm);
        }
        if (perm instanceof ReflectPermission) {
            return this.checkReflectPermission((ReflectPermission)perm);
        }
        if (perm instanceof PropertyPermission) {
            return this.checkPropertyPermission((PropertyPermission)perm);
        }
        if (perm instanceof RuntimePermission) {
            return this.checkRuntimePermission((RuntimePermission)perm);
        }
        if (perm instanceof AWTPermission) {
            return this.checkAWTPermission((AWTPermission)perm);
        }
        if (perm instanceof UnresolvedPermission) {
            return this.checkUnresolvedPermission((UnresolvedPermission)perm);
        }
        if (perm instanceof SerializablePermission) {
            return this.checkSerializablePermission((SerializablePermission)perm);
        }
        if (perm instanceof AudioPermission) {
            return this.checkAudioPermission((AudioPermission)perm);
        }
        if (perm instanceof DelegationPermission) {
            return this.checkDelegationPermission((DelegationPermission)perm);
        }
        if (perm instanceof ServicePermission) {
            return this.checkServicePermission((ServicePermission)perm);
        }
        if (perm instanceof SQLPermission) {
            return this.checkSQLPermission((SQLPermission)perm);
        }
        if (perm instanceof SSLPermission) {
            return this.checkSSLPermission((SSLPermission)perm);
        }
        if (perm instanceof PrivateCredentialPermission) {
            return this.checkPrivateCredentialPermission((PrivateCredentialPermission)perm);
        }
        if (perm instanceof WebServicePermission) {
            return this.checkWebServicePermission((WebServicePermission)perm);
        }
        if (perm instanceof SubjectDelegationPermission) {
            return this.checkSubjectDelegationPermission((SubjectDelegationPermission)perm);
        }
        if (perm instanceof ManagementPermission) {
            return this.checkManagementPermission((ManagementPermission)perm);
        }
        if (perm instanceof MBeanPermission) {
            return this.checkMBeanPermission((MBeanPermission)perm);
        }
        if (perm instanceof MBeanServerPermission) {
            return this.checkMBeanServerPermission((MBeanServerPermission)perm);
        }
        if (perm instanceof MBeanTrustPermission) {
            return this.checkMBeanTrustPermission((MBeanTrustPermission)perm);
        }
        if (perm instanceof NetPermission) {
            return this.checkNetPermission((NetPermission)perm);
        }
        if (perm instanceof AuthPermission) {
            return this.checkAuthPermission((AuthPermission)perm);
        }
        if (perm instanceof SocketPermission) {
            return this.checkSocketPermission((SocketPermission)perm);
        }
        String canonicalName = perm.getClass().getCanonicalName();
        if (canonicalName.startsWith("java")) {
            if (!this.unrecognizedPermissions.contains(perm)) {
                this.unrecognizedPermissions.add(perm);
                logger.debug("Unrecognized permission type: " + canonicalName);
            }
            return false;
        }
        logger.debug("Allowing permission defined by the SUT: " + canonicalName);
        return true;
    }

    private boolean checkIfEvoSuiteRMI(Permission perm) {
        String pattern = "sun.rmi.";
        boolean foundRMI = false;
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.toString().startsWith("sun.rmi.")) continue;
            foundRMI = true;
            break;
        }
        if (!foundRMI) {
            return false;
        }
        boolean foundMasterNode = false;
        block1: for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            for (String masterNodeMethod : masterNodeRemoteMethodNames) {
                if (!element.toString().contains(masterNodeMethod)) continue;
                foundMasterNode = true;
                break block1;
            }
        }
        if (!foundMasterNode) {
            return false;
        }
        if (perm instanceof FilePermission && !perm.getActions().equals("read")) {
            logger.error("EvoSuite RMI is trying to interact with files: " + perm);
            return false;
        }
        return true;
    }

    public boolean checkIfRMIDuringTests(Permission perm) {
        return runningClientOnThread && Thread.currentThread().getName().startsWith("RMI TCP");
    }

    protected boolean checkSocketPermission(SocketPermission perm) {
        return false;
    }

    protected boolean checkAuthPermission(AuthPermission perm) {
        return false;
    }

    protected boolean checkNetPermission(NetPermission perm) {
        return true;
    }

    protected boolean checkMBeanPermission(MBeanPermission perm) {
        return true;
    }

    protected boolean checkMBeanServerPermission(MBeanServerPermission perm) {
        return true;
    }

    protected boolean checkMBeanTrustPermission(MBeanTrustPermission perm) {
        return true;
    }

    protected boolean checkManagementPermission(ManagementPermission perm) {
        String name = perm.getName();
        return name.equals("monitor");
    }

    protected boolean checkSubjectDelegationPermission(SubjectDelegationPermission perm) {
        return true;
    }

    protected boolean checkWebServicePermission(WebServicePermission perm) {
        return false;
    }

    protected boolean checkPrivateCredentialPermission(PrivateCredentialPermission perm) {
        return true;
    }

    protected boolean checkSSLPermission(SSLPermission perm) {
        String name = perm.getName();
        return name.equals("getSSLSessionContext");
    }

    protected boolean checkSQLPermission(SQLPermission perm) {
        return false;
    }

    protected boolean checkServicePermission(ServicePermission perm) {
        return true;
    }

    protected boolean checkDelegationPermission(DelegationPermission perm) {
        return false;
    }

    protected boolean checkAudioPermission(AudioPermission perm) {
        return true;
    }

    protected boolean checkSerializablePermission(SerializablePermission perm) {
        return true;
    }

    protected boolean checkUnresolvedPermission(UnresolvedPermission perm) {
        return false;
    }

    protected boolean checkAllPermission(AllPermission perm) {
        return false;
    }

    protected boolean checkSecurityPermission(SecurityPermission perm) {
        String name = perm.getName();
        if (name.equals("getDomainCombiner") || name.equals("getPolicy") || name.equals("printIdentity") || name.equals("getSignerPrivateKey") || name.startsWith("getProperty.")) {
            return true;
        }
        return name.startsWith("putProviderProperty.");
    }

    protected boolean checkAWTPermission(AWTPermission perm) {
        return "true".equals(AWT_HEADLESS);
    }

    protected boolean checkRuntimePermission(RuntimePermission perm) {
        String name = perm.getName().trim();
        if (name.equals("getClassLoader") || name.equals("createClassLoader") || name.startsWith("accessClassInPackage") || name.startsWith("defineClassInPackage") || name.equals("setContextClassLoader") || name.equals("enableContextClassLoaderOverride") || name.equals("accessDeclaredMembers")) {
            return true;
        }
        if (name.equals("setSecurityManager") || name.equals("createSecurityManager")) {
            return false;
        }
        if ("true".equals(AWT_HEADLESS) && this.isAWTThread()) {
            if (name.equals("shutdownHooks")) {
                return true;
            }
            if (name.equals("modifyThreadGroup")) {
                return true;
            }
            if (name.equals("modifyThread")) {
                return true;
            }
        }
        if (name.startsWith("exitVM")) {
            return false;
        }
        if (name.equals("shutdownHooks")) {
            return RuntimeSettings.mockJVMNonDeterminism;
        }
        if (name.equals("setFactory")) {
            return true;
        }
        if (name.equals("setIO")) {
            return true;
        }
        if (name.equals("reflectionFactoryAccess")) {
            return true;
        }
        if (name.equals("modifyThread") || name.equals("stopThread") || name.equals("modifyThreadGroup")) {
            return true;
        }
        if (name.equals("setDefaultUncaughtExceptionHandler")) {
            return true;
        }
        if (name.startsWith("getenv.") || name.equals("getProtectionDomain") || name.equals("readFileDescriptor")) {
            return true;
        }
        if (name.equals("writeFileDescriptor")) {
            return false;
        }
        if (name.startsWith("loadLibrary.")) {
            String library = name.substring("loadLibrary.".length(), name.length());
            return library.equals("awt") || library.equals("fontmanager") || library.equals("net") || library.equals("lcms") || library.equals("j2pkcs11") || library.equals("nio") || library.equals("laf") || library.endsWith("libmawt.so") || library.equals("jpeg") || library.endsWith("liblwawt.dylib") || library.equals("cmm") || library.equals("t2k") || library.equals("jawt") || library.equals("sunec") || library.equals("management") || library.equals("kcms") || library.startsWith("jaybird") || library.equals("instrument") || library.startsWith("osxui") || library.contains("libawt_lwawt");
        }
        if (name.equals("queuePrintJob")) {
            return false;
        }
        if (name.equals("getStackTrace")) {
            return true;
        }
        if (name.equals("preferences")) {
            return false;
        }
        if (name.equals("charsetProvider") || name.equals("selectorProvider")) {
            return true;
        }
        if (name.equals("getFileSystemAttributes")) {
            return true;
        }
        if (!this.unrecognizedPermissions.contains(perm)) {
            this.unrecognizedPermissions.add(perm);
            logger.warn("SUT asked for a runtime permission that EvoSuite does not recognize: " + name);
        }
        return false;
    }

    protected boolean checkPropertyPermission(PropertyPermission perm) {
        if (perm.getName().equals("sun.font.fontmanager")) {
            return true;
        }
        if (perm.getActions().contains("write") && !this.executingTestCase) {
            return !System.isSystemProperty(perm.getName());
        }
        return System.handlePropertyPermission(perm);
    }

    protected boolean checkReflectPermission(ReflectPermission perm) {
        return true;
    }

    protected boolean checkLoggingPermission(LoggingPermission perm) {
        return true;
    }

    protected boolean checkFilePermission(FilePermission fp) {
        String action = fp.getActions();
        if (action == null) {
            logger.debug("File permission with empty action");
            return false;
        }
        if (action.equals("read")) {
            return true;
        }
        if (RuntimeSettings.useVFS) {
            boolean isTmpFile = fp.getName().equals(VirtualFileSystem.getInstance().getRealTmpFile().getPath());
            boolean isFileHandlerFile = fp.getName().contains(FILE_HANDLER_NAME_PATTERN);
            if (isFileHandlerFile) {
                // empty if block
            }
            if (isTmpFile || isFileHandlerFile) {
                return true;
            }
        }
        String fontDir = USER_DIR + File.separator + ".java" + File.separator + "fonts" + File.separator + JAVA_VERSION;
        return action.equals("write") && fp.getName().startsWith(fontDir);
    }

    static {
        File tmp = null;
        try {
            tmp = File.createTempFile("EvosuiteTmpFile", ".tmp");
            tmp.deleteOnExit();
        }
        catch (Exception e) {
            logger.error("Error while trying to create tmp file: " + e.getMessage());
        }
        tmpFile = tmp;
        boolean bl = RuntimeSettings.mockJVMNonDeterminism;
        runningClientOnThread = false;
    }
}

