/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.sandbox;

import java.awt.AWTPermission;
import java.io.FilePermission;
import java.io.SerializablePermission;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.security.AllPermission;
import java.security.Permission;
import java.security.SecurityPermission;
import java.security.UnresolvedPermission;
import java.sql.SQLPermission;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.LoggingPermission;
import javax.net.ssl.SSLPermission;
import javax.security.auth.AuthPermission;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.kerberos.DelegationPermission;
import javax.security.auth.kerberos.ServicePermission;
import javax.sound.sampled.AudioPermission;
import org.slf4j.Logger;

public class PermissionStatistics {
    private static PermissionStatistics instance = new PermissionStatistics();
    private final Map<String, Map<String, Integer>> allowedCount = new ConcurrentHashMap<String, Map<String, Integer>>();
    private final Map<String, Map<String, Integer>> deniedCount = new ConcurrentHashMap<String, Map<String, Integer>>();
    private final Map<Class<?>, Integer> deniedClassCount = new ConcurrentHashMap();
    private final Set<String> recentAccess = Collections.synchronizedSet(new HashSet());
    private int maxThreads = 1;
    private boolean hasNewExceptions = false;
    private String threadGroupToMonitor;

    private PermissionStatistics() {
    }

    public static PermissionStatistics getInstance() {
        return instance;
    }

    public String[] getRecentFileReadPermissions() {
        return this.recentAccess.toArray(new String[0]);
    }

    public void resetRecentStatistic() {
        this.recentAccess.clear();
    }

    private void rememberRecentReadFilePermissions(Permission permission) {
        try {
            FilePermission fp = (FilePermission)permission;
            if (!fp.getActions().equals("read")) {
                return;
            }
            this.recentAccess.add(fp.getName());
        }
        catch (Exception e) {
            return;
        }
    }

    public void permissionAllowed(Permission permission) {
        this.rememberRecentReadFilePermissions(permission);
        String name = permission.getClass().getName();
        String type = this.getPermissionType(permission);
        if (!this.allowedCount.containsKey(name)) {
            this.allowedCount.put(name, new HashMap());
        }
        if (this.allowedCount.get(name).containsKey(type)) {
            this.allowedCount.get(name).put(type, this.allowedCount.get(name).get(type) + 1);
        } else {
            this.allowedCount.get(name).put(type, 1);
        }
    }

    private int getCurrentCount(Class<?> permissionClass) {
        if (!this.deniedClassCount.containsKey(permissionClass)) {
            this.deniedClassCount.put(permissionClass, 0);
        }
        return this.deniedClassCount.get(permissionClass);
    }

    private void incCurrentCount(Class<?> permissionClass) {
        this.deniedClassCount.put(permissionClass, this.getCurrentCount(permissionClass) + 1);
    }

    private String getPermissionType(Permission permission) {
        String name = permission.getName();
        String actions = permission.getActions();
        String type = "";
        if (actions != null && !actions.isEmpty()) {
            type = type + actions + " ";
        }
        if (name != null && !name.isEmpty()) {
            type = type + name;
        }
        return type;
    }

    public void permissionDenied(Permission permission) {
        this.incCurrentCount(permission.getClass());
        this.rememberRecentReadFilePermissions(permission);
        String permissionClassName = permission.getClass().getName();
        String type = this.getPermissionType(permission);
        if (!this.deniedCount.containsKey(permissionClassName)) {
            this.deniedCount.put(permissionClassName, new HashMap());
        }
        if (this.deniedCount.get(permissionClassName).containsKey(type)) {
            this.deniedCount.get(permissionClassName).put(type, this.deniedCount.get(permissionClassName).get(type) + 1);
        } else {
            this.deniedCount.get(permissionClassName).put(type, 1);
        }
        this.hasNewExceptions = true;
    }

    public int getPermissionDeniedCount(Permission permission) {
        String name = permission.getClass().getName();
        String type = this.getPermissionType(permission);
        if (this.deniedCount.containsKey(name) && this.deniedCount.get(name).containsKey(type)) {
            return this.deniedCount.get(name).get(type);
        }
        return 0;
    }

    public int getNumAllPermission() {
        return this.getCurrentCount(AllPermission.class);
    }

    public int getNumSecurityPermission() {
        return this.getCurrentCount(SecurityPermission.class);
    }

    public int getNumUnresolvedPermission() {
        return this.getCurrentCount(UnresolvedPermission.class);
    }

    public int getNumAWTPermission() {
        return this.getCurrentCount(AWTPermission.class);
    }

    public int getNumFilePermission() {
        return this.getCurrentCount(FilePermission.class);
    }

    public int getNumSerializablePermission() {
        return this.getCurrentCount(SerializablePermission.class);
    }

    public int getNumReflectPermission() {
        return this.getCurrentCount(ReflectPermission.class);
    }

    public int getNumRuntimePermission() {
        return this.getCurrentCount(RuntimePermission.class);
    }

    public int getNumNetPermission() {
        return this.getCurrentCount(NetPermission.class);
    }

    public int getNumSocketPermission() {
        return this.getCurrentCount(SocketPermission.class);
    }

    public int getNumSQLPermission() {
        return this.getCurrentCount(SQLPermission.class);
    }

    public int getNumPropertyPermission() {
        return this.getCurrentCount(PropertyPermission.class);
    }

    public int getNumLoggingPermission() {
        return this.getCurrentCount(LoggingPermission.class);
    }

    public int getNumSSLPermission() {
        return this.getCurrentCount(SSLPermission.class);
    }

    public int getNumAuthPermission() {
        return this.getCurrentCount(AuthPermission.class) + this.getCurrentCount(PrivateCredentialPermission.class) + this.getCurrentCount(DelegationPermission.class) + this.getCurrentCount(ServicePermission.class);
    }

    public int getNumAudioPermission() {
        return this.getCurrentCount(AudioPermission.class);
    }

    public int getNumOtherPermission() {
        int sum = this.getNumAllPermission() + this.getNumSecurityPermission() + this.getNumUnresolvedPermission() + this.getNumAWTPermission() + this.getNumFilePermission() + this.getNumSerializablePermission() + this.getNumReflectPermission() + this.getNumRuntimePermission() + this.getNumNetPermission() + this.getNumSocketPermission() + this.getNumSQLPermission() + this.getNumPropertyPermission() + this.getNumLoggingPermission() + this.getNumSSLPermission() + this.getNumAuthPermission() + this.getNumAudioPermission();
        int total = 0;
        for (int i : this.deniedClassCount.values()) {
            total += i;
        }
        return total - sum;
    }

    public boolean hasDeniedPermissions() {
        return !this.deniedCount.isEmpty();
    }

    public void printStatistics(Logger inputLog) {
        this.forcePermissionInit();
        if (this.hasDeniedPermissions()) {
            inputLog.info("* Permissions denied during test execution: ");
            for (String name : this.deniedCount.keySet()) {
                int remaining;
                inputLog.info("  - " + name + ": ");
                int MAX_TO_PRINT = 4;
                int counter = 0;
                int total = this.deniedCount.get(name).keySet().size();
                boolean printAll = total <= 4;
                for (String type : this.deniedCount.get(name).keySet()) {
                    inputLog.info("         " + type + ": " + this.deniedCount.get(name).get(type));
                    if (printAll || ++counter < 3) continue;
                    break;
                }
                if ((remaining = total - counter) <= 1) continue;
                inputLog.info("         and other " + remaining + " cases of action/name for this exception class");
            }
        }
    }

    private void forcePermissionInit() {
        this.getNumAllPermission();
        this.getNumSecurityPermission();
        this.getNumUnresolvedPermission();
        this.getNumAWTPermission();
        this.getNumFilePermission();
        this.getNumSerializablePermission();
        this.getNumReflectPermission();
        this.getNumRuntimePermission();
        this.getNumNetPermission();
        this.getNumSocketPermission();
        this.getNumSQLPermission();
        this.getNumPropertyPermission();
        this.getNumLoggingPermission();
        this.getNumSSLPermission();
        this.getNumAuthPermission();
        this.getNumAudioPermission();
        this.getNumOtherPermission();
        this.getMaxThreads();
    }

    public void countThreads(int numThreads) {
        if (this.threadGroupToMonitor != null && Thread.currentThread().getThreadGroup().getName().equals(this.threadGroupToMonitor)) {
            this.maxThreads = Math.max(this.maxThreads, numThreads);
        }
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public boolean getAndResetExceptionInfo() {
        if (this.hasNewExceptions) {
            this.hasNewExceptions = false;
            return true;
        }
        return false;
    }

    public void setThreadGroupToMonitor(String threadGroupToMonitor) {
        this.threadGroupToMonitor = threadGroupToMonitor;
    }
}

