/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.sandbox;

import java.util.Set;
import org.evosuite.runtime.sandbox.MSecurityManager;
import org.evosuite.runtime.sandbox.PermissionStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sandbox {
    private static Logger logger = LoggerFactory.getLogger(Sandbox.class);
    private static volatile MSecurityManager manager;
    private static volatile int counter;
    private static boolean checkForInitialization;

    public static void setCheckForInitialization(boolean checkForInitialization) {
        Sandbox.checkForInitialization = checkForInitialization;
    }

    public static synchronized void initializeSecurityManagerForSUT(Set<Thread> privileged) {
        if (manager == null) {
            manager = new MSecurityManager();
            if (privileged == null) {
                manager.makePriviligedAllCurrentThreads();
            } else {
                for (Thread t : privileged) {
                    manager.addPrivilegedThread(t);
                }
            }
            manager.apply();
        } else {
            logger.warn("Sandbox can be initalized only once");
        }
        ++counter;
    }

    public static synchronized void initializeSecurityManagerForSUT() {
        Sandbox.initializeSecurityManagerForSUT(null);
    }

    public static void addPriviligedThread(Thread t) {
        if (manager != null) {
            manager.addPrivilegedThread(t);
        }
    }

    public static synchronized Set<Thread> resetDefaultSecurityManager() {
        Set<Thread> privileged = null;
        if (manager != null) {
            privileged = manager.getPriviledThreads();
        }
        if (--counter == 0) {
            if (manager != null) {
                manager.restoreDefaultManager();
            }
            manager = null;
        }
        return privileged;
    }

    public static boolean isSecurityManagerInitialized() {
        return manager != null;
    }

    public static void goingToExecuteSUTCode() {
        if (!Sandbox.isSecurityManagerInitialized()) {
            if (checkForInitialization) {
                logger.error("Sandbox is not initialized!");
            }
            return;
        }
        manager.goingToExecuteTestCase();
        PermissionStatistics.getInstance().getAndResetExceptionInfo();
    }

    public static void doneWithExecutingSUTCode() {
        if (!Sandbox.isSecurityManagerInitialized()) {
            if (checkForInitialization) {
                logger.error("Sandbox is not initialized!");
            }
            return;
        }
        manager.goingToEndTestCase();
    }

    public static void goingToExecuteUnsafeCodeOnSameThread() throws SecurityException, IllegalStateException {
        if (!Sandbox.isSecurityManagerInitialized()) {
            return;
        }
        manager.goingToExecuteUnsafeCodeOnSameThread();
    }

    public static void doneWithExecutingUnsafeCodeOnSameThread() throws SecurityException, IllegalStateException {
        if (!Sandbox.isSecurityManagerInitialized()) {
            return;
        }
        manager.doneWithExecutingUnsafeCodeOnSameThread();
    }

    public static boolean isSafeToExecuteSUTCode() {
        if (!Sandbox.isSecurityManagerInitialized()) {
            return false;
        }
        return manager.isSafeToExecuteSUTCode();
    }

    static {
        checkForInitialization = false;
    }

    public static enum SandboxMode {
        OFF,
        RECOMMENDED,
        IO;

    }
}

