/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.thread;

import org.evosuite.runtime.RuntimeSettings;

public class ThreadCounter {
    private static final ThreadCounter singleton = new ThreadCounter();
    private volatile int counter;

    private ThreadCounter() {
        this.resetSingleton();
    }

    public static ThreadCounter getInstance() {
        return singleton;
    }

    public synchronized void resetSingleton() {
        this.counter = 0;
    }

    public synchronized void checkIfCanStartNewThread() throws RuntimeException {
        if (this.counter == RuntimeSettings.maxNumberOfThreads) {
            throw new RuntimeException("This test case has tried to start too many threads. Maximum allowed per test is " + RuntimeSettings.maxNumberOfThreads + " threads.");
        }
        ++this.counter;
    }
}

