/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.vfs;

import java.io.File;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.System;
import org.evosuite.runtime.vfs.VFolder;

public abstract class FSObject {
    private volatile boolean readPermission = true;
    private volatile boolean writePermission = true;
    private volatile boolean executePermission = true;
    protected volatile String path;
    protected final VFolder parent;
    protected volatile boolean deleted;
    protected volatile long lastModified;

    public FSObject(String path, VFolder parent) {
        this.parent = parent;
        this.deleted = false;
        this.lastModified = this.getCurrentTimeMillis();
        this.path = this.isSpecialWindowsRoot(path) ? path : this.normalizePath(path);
    }

    protected long getCurrentTimeMillis() {
        if (RuntimeSettings.mockJVMNonDeterminism) {
            return System.getCurrentTimeMillisForVFS();
        }
        return java.lang.System.currentTimeMillis();
    }

    private boolean isSpecialWindowsRoot(String givenPath) {
        return this.parent != null && givenPath != null && this.parent.isRoot() && givenPath.endsWith(":") && !File.separator.equals("/");
    }

    public boolean rename(String newPath) {
        if (!this.isWritePermission() || !this.parent.isWritePermission()) {
            return false;
        }
        this.path = newPath;
        return true;
    }

    public boolean delete() {
        this.parent.removeChild(this.getName());
        this.deleted = true;
        return this.deleted;
    }

    public boolean isFolder() {
        return this instanceof VFolder;
    }

    public String getName() {
        if (this.path == null) {
            return null;
        }
        if (this.isSpecialWindowsRoot(this.path)) {
            return this.path;
        }
        return new File(this.path).getName();
    }

    public String normalizePath(String rawPath) {
        if (rawPath == null) {
            return null;
        }
        return new File(rawPath).getAbsolutePath();
    }

    public boolean isReadPermission() {
        return this.readPermission;
    }

    public void setReadPermission(boolean readPermission) {
        this.readPermission = readPermission;
    }

    public boolean isWritePermission() {
        return this.writePermission;
    }

    public void setWritePermission(boolean writePermission) {
        this.writePermission = writePermission;
    }

    public boolean isExecutePermission() {
        return this.executePermission;
    }

    public void setExecutePermission(boolean executePermission) {
        this.executePermission = executePermission;
    }

    public String getPath() {
        return this.path == null ? "" : this.path;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public String toString() {
        return this.getPath();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean setLastModified(long lastModified) {
        if (!this.isWritePermission()) {
            return false;
        }
        this.lastModified = lastModified;
        return true;
    }

    public VFolder getParent() {
        return this.parent;
    }
}

