/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.vnet;

import java.util.ArrayDeque;
import java.util.Queue;
import org.evosuite.runtime.vnet.EndPointInfo;

public class NativeTcp {
    private final Queue<Byte> localBuffer;
    private final Queue<Byte> remoteBuffer;
    private volatile EndPointInfo localEndPoint;
    private final EndPointInfo remoteEndPoint;

    public NativeTcp(EndPointInfo localEndPoint, EndPointInfo remoteEndPoint) {
        if (remoteEndPoint == null) {
            throw new IllegalArgumentException("Remote end point cannot be null");
        }
        this.localEndPoint = localEndPoint;
        this.remoteEndPoint = remoteEndPoint;
        this.localBuffer = new ArrayDeque<Byte>();
        this.remoteBuffer = new ArrayDeque<Byte>();
    }

    public boolean isBound() {
        return this.localEndPoint != null;
    }

    public void bind(EndPointInfo local) throws IllegalStateException {
        if (this.isBound()) {
            throw new IllegalStateException("Connection is already bound");
        }
        this.localEndPoint = local;
    }

    public synchronized void writeToRemote(byte b) {
        this.remoteBuffer.add(b);
    }

    public synchronized int readInSUTfromRemote() {
        if (this.localBuffer.isEmpty()) {
            return -1;
        }
        return this.localBuffer.poll().byteValue();
    }

    public synchronized void writeToSUT(byte b) {
        this.localBuffer.add(b);
    }

    public synchronized int readInTestFromSUT() {
        if (this.remoteBuffer.isEmpty()) {
            return -1;
        }
        return this.remoteBuffer.poll().byteValue();
    }

    public synchronized int getAmountOfDataInLocalBuffer() {
        return this.localBuffer.size();
    }

    public synchronized int getAmountOfDataInRemoteBuffer() {
        return this.remoteBuffer.size();
    }

    public EndPointInfo getLocalEndPoint() {
        return this.localEndPoint;
    }

    public EndPointInfo getRemoteEndPoint() {
        return this.remoteEndPoint;
    }
}

