/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.vnet;

import org.evosuite.runtime.vnet.EvoSuiteAddress;
import org.evosuite.runtime.vnet.NativeTcp;
import org.evosuite.runtime.vnet.VirtualNetwork;

public class NetworkHandling {
    private static final String DEFAULT_REMOTE_ADDRESS = "127.0.0.42";

    public static boolean sendDataOnTcp(EvoSuiteAddress sutServer, byte[] data) {
        if (sutServer == null) {
            return false;
        }
        NativeTcp connection = VirtualNetwork.getInstance().registerIncomingTcpConnection(DEFAULT_REMOTE_ADDRESS, VirtualNetwork.getInstance().getNewRemoteEphemeralPort(), sutServer.getHost(), sutServer.getPort());
        if (data != null) {
            for (byte b : data) {
                connection.writeToSUT(b);
            }
        }
        return true;
    }

    public static boolean sendMessageOnTcp(EvoSuiteAddress sutServer, String message) {
        return NetworkHandling.sendDataOnTcp(sutServer, message.getBytes());
    }
}

