/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.vnet;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkInterfaceState {
    private static final Logger logger = LoggerFactory.getLogger(NetworkInterfaceState.class);
    private NetworkInterface ni;
    private final List<InetAddress> localAddresses;
    private final byte[] mac;
    private final int mtu;
    private final boolean loopback;

    public NetworkInterfaceState(String name, int index, byte[] mac, int mtu, boolean loopback, InetAddress anAddress) {
        this.mtu = mtu;
        this.loopback = loopback;
        this.mac = mac != null ? (byte[])mac.clone() : null;
        this.localAddresses = Collections.singletonList(anAddress);
        try {
            Constructor constructor = NetworkInterface.class.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            this.ni = (NetworkInterface)constructor.newInstance(new Object[0]);
            Field nameField = NetworkInterface.class.getDeclaredField("name");
            nameField.setAccessible(true);
            Field indexField = NetworkInterface.class.getDeclaredField("index");
            indexField.setAccessible(true);
            nameField.set(this.ni, name);
            indexField.set(this.ni, index);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error("Reflection problems: " + e.getMessage());
        }
    }

    public NetworkInterface getNetworkInterface() {
        return this.ni;
    }

    public List<InetAddress> getLocalAddresses() {
        return this.localAddresses;
    }

    public byte[] getMacAddr() {
        return (byte[])this.mac.clone();
    }

    public int getMTU() {
        return this.mtu;
    }

    public boolean isLoopback() {
        return this.loopback;
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean supportsMulticast() {
        return true;
    }

    public boolean isPointToPoint() {
        return false;
    }

    public boolean isUp() {
        return true;
    }

    public NetworkInterface getParent() {
        return null;
    }
}

