/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.vnet;

import java.io.IOException;
import org.evosuite.runtime.mock.java.net.SocketIn;
import org.evosuite.runtime.mock.java.net.SocketOut;
import org.evosuite.runtime.vnet.EndPointInfo;
import org.evosuite.runtime.vnet.NativeTcp;
import org.evosuite.runtime.vnet.VirtualNetwork;

public class RemoteTcpServer {
    private final NativeTcp connection;
    private final SocketOut out;
    private final SocketIn in;

    public RemoteTcpServer(EndPointInfo address) throws IllegalArgumentException {
        if (!address.getType().equals((Object)VirtualNetwork.ConnectionType.TCP)) {
            throw new IllegalArgumentException("Invalid type: " + (Object)((Object)address.getType()));
        }
        this.connection = new NativeTcp(null, address);
        this.in = new SocketIn(this.connection, false);
        this.out = new SocketOut(this.connection, false);
        VirtualNetwork.getInstance().addRemoteTcpServer(this);
    }

    public EndPointInfo getAddress() {
        return this.connection.getRemoteEndPoint();
    }

    public synchronized NativeTcp connect(EndPointInfo sutAddress) throws IOException {
        if (this.connection.isBound()) {
            throw new IOException("Server is already connected");
        }
        if (sutAddress == null) {
            throw new IOException("Null local SUT address");
        }
        this.connection.bind(sutAddress);
        return this.connection;
    }

    public boolean sendMessage(String msg) {
        try {
            this.out.write(msg.getBytes());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public String getAllReceivedDataAsString() {
        if (!this.connection.isBound()) {
            return null;
        }
        try {
            byte[] buffer = new byte[this.in.available()];
            this.in.read(buffer);
            return new String(buffer);
        }
        catch (IOException e) {
            return null;
        }
    }
}

