/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.vnet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.evosuite.runtime.mock.java.net.MockInetAddress;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.evosuite.runtime.vnet.DNS;
import org.evosuite.runtime.vnet.EndPointInfo;
import org.evosuite.runtime.vnet.NativeTcp;
import org.evosuite.runtime.vnet.NetworkInterfaceState;
import org.evosuite.runtime.vnet.RemoteTcpServer;

public class VirtualNetwork {
    private static final VirtualNetwork instance = new VirtualNetwork();
    private static final int START_OF_REMOTE_EPHEMERAL_PORTS = 40000;
    private final Set<EndPointInfo> localListeningPorts = new CopyOnWriteArraySet<EndPointInfo>();
    private final Set<EndPointInfo> remoteContactedPorts;
    private final Map<EndPointInfo, Queue<RemoteTcpServer>> remoteCurrentServers;
    private final Map<EndPointInfo, Queue<NativeTcp>> incomingConnections = new ConcurrentHashMap<EndPointInfo, Queue<NativeTcp>>();
    private final Set<NativeTcp> openedTcpConnections = new CopyOnWriteArraySet<NativeTcp>();
    private final AtomicInteger remotePortIndex = new AtomicInteger(40000);
    private final List<NetworkInterfaceState> networkInterfaces;
    private DNS dns;

    private VirtualNetwork() {
        this.remoteContactedPorts = new CopyOnWriteArraySet<EndPointInfo>();
        this.remoteCurrentServers = new ConcurrentHashMap<EndPointInfo, Queue<RemoteTcpServer>>();
        this.networkInterfaces = new CopyOnWriteArrayList<NetworkInterfaceState>();
        this.dns = new DNS();
    }

    public static VirtualNetwork getInstance() {
        return instance;
    }

    public void reset() {
        this.dns = new DNS();
        this.localListeningPorts.clear();
        this.incomingConnections.clear();
        this.remotePortIndex.set(40000);
        this.remoteCurrentServers.clear();
        this.networkInterfaces.clear();
        this.openedTcpConnections.clear();
        this.remoteContactedPorts.clear();
    }

    public void init() {
        this.reset();
        this.initNetworkInterfaces();
        MockURL.initStaticState();
    }

    public int getNewRemoteEphemeralPort() {
        return this.remotePortIndex.getAndIncrement();
    }

    public NetworkInterfaceState getNetworkInterfaceState(String name) {
        for (NetworkInterfaceState ni : this.networkInterfaces) {
            if (!ni.getNetworkInterface().getName().equals(name)) continue;
            return ni;
        }
        return null;
    }

    public List<NetworkInterfaceState> getAllNetworkInterfaceStates() {
        return new ArrayList<NetworkInterfaceState>(this.networkInterfaces);
    }

    public String dnsResolve(String host) {
        return this.dns.resolve(host);
    }

    public synchronized NativeTcp registerIncomingTcpConnection(String originAddr, int originPort, String destAddr, int destPort) {
        EndPointInfo origin = new EndPointInfo(originAddr, originPort, ConnectionType.TCP);
        EndPointInfo dest = new EndPointInfo(destAddr, destPort, ConnectionType.TCP);
        Queue<NativeTcp> queue = this.incomingConnections.get(dest);
        if (queue == null) {
            queue = new ConcurrentLinkedQueue<NativeTcp>();
            this.incomingConnections.put(dest, queue);
        }
        NativeTcp connection = new NativeTcp(dest, origin);
        queue.add(connection);
        return connection;
    }

    public synchronized NativeTcp pullTcpConnection(String localAddress, int localPort) {
        EndPointInfo local = new EndPointInfo(localAddress, localPort, ConnectionType.TCP);
        Queue<NativeTcp> queue = this.incomingConnections.get(local);
        if (queue == null || queue.isEmpty()) {
            return null;
        }
        NativeTcp connection = queue.poll();
        this.openedTcpConnections.add(connection);
        return connection;
    }

    public synchronized boolean openTcpServer(String addr, int port) {
        EndPointInfo info = new EndPointInfo(addr, port, ConnectionType.TCP);
        if (this.localListeningPorts.contains(info)) {
            return false;
        }
        if (!this.isValidLocalServer(info)) {
            return false;
        }
        this.localListeningPorts.add(info);
        return true;
    }

    public Set<NativeTcp> getViewOfOpenedTcpConnections() {
        return Collections.unmodifiableSet(this.openedTcpConnections);
    }

    public synchronized void addRemoteTcpServer(RemoteTcpServer server) {
        Queue<RemoteTcpServer> queue = this.remoteCurrentServers.get(server.getAddress());
        if (queue == null) {
            queue = new ConcurrentLinkedQueue<RemoteTcpServer>();
            this.remoteCurrentServers.put(server.getAddress(), queue);
        }
        queue.add(server);
    }

    public synchronized NativeTcp connectToRemoteAddress(EndPointInfo localOrigin, EndPointInfo remoteTarget) throws IllegalArgumentException, IOException {
        if (localOrigin == null || remoteTarget == null) {
            throw new IllegalArgumentException("Null input");
        }
        if (!this.isValidLocalServer(localOrigin)) {
            throw new IllegalArgumentException("Invalid local address: " + localOrigin);
        }
        this.remoteContactedPorts.add(remoteTarget);
        Queue<RemoteTcpServer> queue = this.remoteCurrentServers.get(remoteTarget);
        if (queue == null || queue.isEmpty()) {
            throw new IOException("Remote address/port is not opened: " + remoteTarget);
        }
        RemoteTcpServer server = queue.poll();
        NativeTcp connection = server.connect(localOrigin);
        return connection;
    }

    private boolean isValidLocalServer(EndPointInfo info) {
        return true;
    }

    private void initNetworkInterfaces() {
        try {
            NetworkInterfaceState loopback = new NetworkInterfaceState("Evo_lo0", 1, null, 16384, true, MockInetAddress.getByName("127.0.0.1"));
            this.networkInterfaces.add(loopback);
            NetworkInterfaceState wifi = new NetworkInterfaceState("Evo_en0", 5, new byte[]{0, 42, 0, 42, 0, 42}, 1500, false, MockInetAddress.getByName("142.42.42.42"));
            this.networkInterfaces.add(wifi);
        }
        catch (Exception e) {
            throw new RuntimeException("EvoSuite error: " + e.getMessage());
        }
    }

    public static enum ConnectionType {
        UDP,
        TCP;

    }
}

