/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.seeding.CollectParameterTypesVisitor;
import org.evosuite.setup.DependencyAnalysis;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CastClassAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(CastClassAnalyzer.class);
    private final Map<Type, Integer> castClassMap = new HashMap<Type, Integer>();

    public Map<Type, Integer> analyze(String className) {
        ClassNode targetClass = DependencyAnalysis.getClassNode(className);
        if (targetClass != null) {
            this.handle(targetClass, 0);
        }
        if (Properties.INSTRUMENT_PARENT) {
            this.handleSuperClasses(targetClass);
        }
        return this.castClassMap;
    }

    public void handleSuperClasses(ClassNode targetClass) {
        String superClassName = targetClass.superName;
        if (superClassName == null || superClassName.isEmpty()) {
            return;
        }
        if (superClassName.equals("java/lang/Object")) {
            return;
        }
        logger.debug("Getting casts for superclass: " + superClassName);
        ClassNode superClass = DependencyAnalysis.getClassNode(superClassName);
        List methods = superClass.methods;
        for (MethodNode mn : methods) {
            logger.debug("Method: " + mn.name);
            if (mn.name.equals("<init>") || mn.name.equals("<clinit>") || (mn.access & 0x400) == 1024 || (mn.access & 1) != 1) continue;
            this.handleMethodNode(superClass, mn, 0);
        }
        this.handleSuperClasses(superClass);
    }

    private void handleClassSignature(ClassNode cn) {
        CollectParameterTypesVisitor visitor = new CollectParameterTypesVisitor(cn.name);
        if (cn.signature != null) {
            new SignatureReader(cn.signature).accept(visitor);
            for (Type castType : visitor.getClasses()) {
                if (this.castClassMap.containsKey(castType)) continue;
                logger.debug("Adding new cast class from signature visitor: " + castType);
                this.castClassMap.put(castType, 1);
            }
        }
    }

    public void handle(ClassNode targetClass, int depth) {
        this.handleClassSignature(targetClass);
        List methods = targetClass.methods;
        for (MethodNode mn : methods) {
            logger.debug("Method: " + mn.name);
            this.handleMethodNode(targetClass, mn, depth);
        }
    }

    public void handle(ClassNode targetClass, String methodName, int depth) {
        this.handleClassSignature(targetClass);
        List methods = targetClass.methods;
        for (MethodNode mn : methods) {
            if (!methodName.equals(mn.name + mn.desc)) continue;
            this.handleMethodNode(targetClass, mn, depth);
        }
    }

    public void handle(String className, String methodName, int depth) {
        ClassNode cn = DependencyAnalysis.getClassNode(className);
        if (cn == null) {
            return;
        }
        this.handle(cn, methodName, depth);
    }

    public void handleMethodNode(ClassNode cn, MethodNode mn, int depth) {
        if (mn.signature != null) {
            logger.debug("Visiting signature: " + mn.signature);
            CollectParameterTypesVisitor visitor = new CollectParameterTypesVisitor(cn.name);
            new SignatureReader(mn.signature).accept(visitor);
            for (Type castType : visitor.getClasses()) {
                if (this.castClassMap.containsKey(castType)) continue;
                logger.debug("Adding new cast class from signature visitor: " + castType);
                this.castClassMap.put(castType, depth + 1);
            }
        }
        InsnList instructions = mn.instructions;
        ListIterator iterator = instructions.iterator();
        while (iterator.hasNext()) {
            Type castType;
            TypeInsnNode typeNode;
            AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
            if (insn.getOpcode() == 192) {
                typeNode = (TypeInsnNode)insn;
                castType = Type.getObjectType(typeNode.desc);
                while (castType.getSort() == 9) {
                    castType = castType.getElementType();
                }
                logger.debug("Adding new cast class from cast: " + castType);
                if (this.castClassMap.containsKey(castType)) continue;
                this.castClassMap.put(castType, depth + 1);
                continue;
            }
            if (insn.getOpcode() == 193) {
                typeNode = (TypeInsnNode)insn;
                castType = Type.getObjectType(typeNode.desc);
                while (castType.getSort() == 9) {
                    castType = castType.getElementType();
                }
                logger.debug("Adding new cast class from instanceof: " + castType);
                if (this.castClassMap.containsKey(castType)) continue;
                this.castClassMap.put(castType, depth + 1);
                continue;
            }
            if (insn.getOpcode() != 18) continue;
            LdcInsnNode ldcNode = (LdcInsnNode)insn;
            if (!(ldcNode.cst instanceof Type)) continue;
            Type type = (Type)ldcNode.cst;
            while (type.getSort() == 9) {
                type = type.getElementType();
            }
            if (this.castClassMap.containsKey(type)) continue;
            this.castClassMap.put(type, depth + 1);
        }
    }
}

