/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.setup.DependencyAnalysis;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class PrimitivePoolMethodAdapter
extends MethodVisitor {
    private final ConstantPoolManager poolManager = ConstantPoolManager.getInstance();
    private final String className;

    public PrimitivePoolMethodAdapter(MethodVisitor mv, String className) {
        super(327680, mv);
        this.className = className;
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        for (int key : keys) {
            if (DependencyAnalysis.isTargetClassName(this.className)) {
                this.poolManager.addSUTConstant(key);
                continue;
            }
            this.poolManager.addNonSUTConstant(key);
        }
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        if (opcode == 16 || opcode == 17) {
            if (DependencyAnalysis.isTargetClassName(this.className)) {
                this.poolManager.addSUTConstant(operand);
            } else {
                this.poolManager.addNonSUTConstant(operand);
            }
        }
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        if (DependencyAnalysis.isTargetClassName(this.className)) {
            this.poolManager.addSUTConstant(cst);
        } else {
            this.poolManager.addNonSUTConstant(cst);
        }
        super.visitLdcInsn(cst);
    }

    @Override
    public void visitInsn(int opcode) {
        Number constant = null;
        switch (opcode) {
            case 3: {
                constant = 0;
                break;
            }
            case 4: {
                constant = 1;
                break;
            }
            case 5: {
                constant = 2;
                break;
            }
            case 6: {
                constant = 3;
                break;
            }
            case 7: {
                constant = 4;
                break;
            }
            case 8: {
                constant = 5;
                break;
            }
            case 2: {
                constant = -1;
                break;
            }
            case 9: {
                constant = 0L;
                break;
            }
            case 10: {
                constant = 1L;
                break;
            }
            case 14: {
                constant = 0.0;
                break;
            }
            case 15: {
                constant = 1.0;
                break;
            }
            case 11: {
                constant = Float.valueOf(0.0f);
                break;
            }
            case 12: {
                constant = Float.valueOf(1.0f);
                break;
            }
            case 13: {
                constant = Float.valueOf(2.0f);
            }
        }
        if (constant != null) {
            if (DependencyAnalysis.isTargetClassName(this.className)) {
                this.poolManager.addSUTConstant(constant);
            } else {
                this.poolManager.addNonSUTConstant(constant);
            }
        }
        super.visitInsn(opcode);
    }
}

