/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import java.util.LinkedHashSet;
import java.util.Set;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;

public final class TestCaseRecycler
implements SearchListener {
    private static TestCaseRecycler instance;
    private final Set<TestCase> testPool = new LinkedHashSet<TestCase>();

    public static TestCaseRecycler getInstance() {
        if (instance == null) {
            instance = new TestCaseRecycler();
        }
        return instance;
    }

    private TestCaseRecycler() {
    }

    @Override
    public void searchStarted(GeneticAlgorithm<?> algorithm) {
    }

    @Override
    public void iteration(GeneticAlgorithm<?> algorithm) {
    }

    @Override
    public void searchFinished(GeneticAlgorithm<?> algorithm) {
        Chromosome individual = algorithm.getBestIndividual();
        if (individual instanceof TestChromosome) {
            TestChromosome testChromosome = (TestChromosome)individual;
            this.testPool.add(testChromosome.getTestCase());
        } else if (individual instanceof TestSuiteChromosome) {
            TestSuiteChromosome testSuiteChromosome = (TestSuiteChromosome)individual;
            this.testPool.addAll(testSuiteChromosome.getTests());
        }
    }

    @Override
    public void fitnessEvaluation(Chromosome individual) {
    }

    @Override
    public void modification(Chromosome individual) {
    }
}

