/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.util.ArrayList;
import java.util.List;

public class CallContext {
    private final List<Call> context = new ArrayList<Call>();

    public CallContext(StackTraceElement[] stackTrace) {
        int startPos = stackTrace.length - 1;
        while (stackTrace[startPos].getClassName().startsWith("java") || stackTrace[startPos].getClassName().startsWith("sun") || stackTrace[startPos].getClassName().startsWith("org.evosuite")) {
            --startPos;
        }
        int endPos = 0;
        while (stackTrace[endPos].getClassName().startsWith("java") || stackTrace[endPos].getClassName().startsWith("sun") || stackTrace[endPos].getClassName().startsWith("org.evosuite")) {
            ++endPos;
        }
        for (int i = startPos; i >= endPos; --i) {
            StackTraceElement element = stackTrace[i];
            this.context.add(new Call(element.getClassName(), element.getMethodName()));
        }
    }

    public CallContext(String className, String methodName) {
        this.context.add(new Call(className, methodName));
    }

    public CallContext() {
    }

    public void addCallingMethod(String className, String methodName) {
        this.context.add(0, new Call(className, methodName));
    }

    public void addCalledMethod(String className, String methodName) {
        this.context.add(new Call(className, methodName));
    }

    public CallContext getSuperContext(String className, String methodName) {
        CallContext copy = new CallContext();
        copy.context.add(new Call(className, methodName));
        for (Call call : this.context) {
            copy.context.add(call);
        }
        return copy;
    }

    public boolean matches(StackTraceElement[] stackTrace) {
        return true;
    }

    public String getRootClassName() {
        return this.context.get(0).getClassName();
    }

    public String getRootMethodName() {
        return this.context.get(0).getMethodName();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Call call : this.context) {
            builder.append(call.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallContext other = (CallContext)obj;
        return !(this.context == null ? other.context != null : !this.context.equals(other.context));
    }

    public boolean matches(CallContext other) {
        if (other.context.size() != this.context.size()) {
            return false;
        }
        for (int i = 0; i < this.context.size(); ++i) {
            Call call2;
            Call call1 = this.context.get(i);
            if (call1.matches(call2 = other.context.get(i))) continue;
            return false;
        }
        return true;
    }

    private static class Call {
        private final String className;
        private final String methodName;

        public Call(String classname, String methodName) {
            this.className = classname;
            this.methodName = methodName;
        }

        public Call(Call call) {
            this.className = call.className;
            this.methodName = call.methodName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Call other = (Call)obj;
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            return !(this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName));
        }

        public boolean matches(Call other) {
            if (!other.getClassName().equals(this.className)) {
                return false;
            }
            return this.methodName.startsWith(other.getMethodName());
        }

        public String toString() {
            return this.className + ":" + this.methodName;
        }
    }
}

