/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.classpath.ResourceList;
import org.evosuite.setup.CallContext;
import org.evosuite.setup.CallTreeEntry;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallTree
implements Iterable<CallTreeEntry> {
    private static final Logger logger = LoggerFactory.getLogger(CallTree.class);
    private final String className;
    private final Set<CallTreeEntry> calls = new LinkedHashSet<CallTreeEntry>();
    private final Set<CallTreeEntry> rootCalls = new LinkedHashSet<CallTreeEntry>();
    private final Map<CallTreeEntry, Set<CallTreeEntry>> callMap = new LinkedHashMap<CallTreeEntry, Set<CallTreeEntry>>();
    private final Set<String> callTreeClasses = new LinkedHashSet<String>();
    private final Set<CallContext> publicMethods = new LinkedHashSet<CallContext>();

    public CallTree(String className) {
        this.className = className;
    }

    public void addPublicMethod(String className, String methodName) {
        this.publicMethods.add(new CallContext(ResourceList.getClassNameFromResourcePath(className), methodName));
    }

    public void addCall(String owner, String methodName, String targetClass, String targetMethod) {
        CallTreeEntry call = new CallTreeEntry(owner, methodName, targetClass, targetMethod);
        logger.info("Adding new call: " + call.toString());
        this.calls.add(call);
        if (owner.equals(this.className)) {
            this.rootCalls.add(call);
        }
        if (!this.callMap.containsKey(call)) {
            this.callMap.put(call, new LinkedHashSet());
        }
        this.callTreeClasses.add(targetClass.replaceAll("/", "."));
    }

    public Set<String> getClasses() {
        return this.callTreeClasses;
    }

    public boolean hasCall(String owner, String methodName, String targetClass, String targetMethod) {
        CallTreeEntry call = new CallTreeEntry(owner, methodName, targetClass, targetMethod);
        return this.calls.contains(call);
    }

    public void addCalls(Set<CallTreeEntry> calls) {
        this.calls.addAll(calls);
        for (CallTreeEntry call : calls) {
            if (!call.getSourceClass().equals(this.className)) continue;
            this.rootCalls.add(call);
        }
    }

    public Set<CallTreeEntry> getCallsFrom(String owner, String methodName) {
        LinkedHashSet<CallTreeEntry> callSet = new LinkedHashSet<CallTreeEntry>();
        for (CallTreeEntry call : this.rootCalls) {
            if (!call.getSourceMethod().equals(methodName)) continue;
            callSet.addAll(this.getCallsFrom(call));
        }
        return callSet;
    }

    public Set<CallTreeEntry> getCallsFrom(CallTreeEntry call) {
        LinkedHashSet<CallTreeEntry> callSet = new LinkedHashSet<CallTreeEntry>();
        for (CallTreeEntry otherCall : this.rootCalls) {
        }
        return callSet;
    }

    public Set<CallContext> getPublicContext(String className, String methodName) {
        HashSet<CallContext> contexts = new HashSet<CallContext>();
        for (CallContext context : this.publicMethods) {
            if (!context.getRootClassName().equals(className) || !context.getRootMethodName().equals(methodName)) continue;
            contexts.add(context);
            break;
        }
        return contexts;
    }

    public Set<CallContext> getAllContexts(String className, String methodName) {
        Set<CallContext> contexts = this.getPublicContext(className, methodName);
        for (CallTreeEntry entry : this.calls) {
            if (!entry.getTargetClass().equals(className) || !entry.getTargetMethod().equals(methodName)) continue;
            CallContext targetContext = new CallContext(className, methodName);
            contexts.addAll(this.getDirectCallingContext(targetContext));
        }
        return contexts;
    }

    private Set<CallContext> getDirectCallingContext(CallContext context) {
        LinkedHashSet<CallContext> contexts = new LinkedHashSet<CallContext>();
        for (CallTreeEntry entry : this.calls) {
            if (!entry.getTargetClass().equals(context.getRootClassName()) || !entry.getTargetMethod().equals(context.getRootMethodName())) continue;
            CallContext superContext = context.getSuperContext(entry.getSourceClass(), entry.getSourceMethod());
            contexts.add(superContext);
        }
        return contexts;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isCalledClass(String className) {
        for (CallTreeEntry call : this.calls) {
            if (!call.getTargetClass().equals(className)) continue;
            return true;
        }
        return false;
    }

    public boolean isCalledMethod(String className, String methodName) {
        for (CallTreeEntry call : this.calls) {
            if (!call.getTargetClass().equals(className) || !call.getTargetMethod().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<CallTreeEntry> iterator() {
        return this.calls.iterator();
    }

    public String toString() {
        LoggingUtils.getEvoLogger().info("Calls: " + this.calls.size());
        StringBuilder builder = new StringBuilder();
        for (CallTreeEntry call : this.calls) {
            builder.append(call.toString());
            builder.append("\n");
        }
        return builder.toString();
    }
}

