/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import org.evosuite.Properties;
import org.evosuite.instrumentation.BytecodeInstrumentation;
import org.evosuite.setup.CallTree;
import org.evosuite.setup.CallTreeEntry;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.InheritanceTree;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallTreeGenerator {
    private static Logger logger = LoggerFactory.getLogger(CallTreeGenerator.class);

    public static CallTree analyze(String className) {
        ClassNode targetClass = DependencyAnalysis.getClassNode(className);
        CallTree callTree = new CallTree(className);
        if (targetClass != null) {
            CallTreeGenerator.handle(callTree, targetClass, 0);
        }
        if (Properties.INSTRUMENT_PARENT) {
            CallTreeGenerator.handleSuperClasses(callTree, targetClass);
        }
        return callTree;
    }

    private static boolean isOverridden(String methodName) {
        return true;
    }

    private static void handleSuperClasses(CallTree callTree, ClassNode targetClass) {
        String superClassName = targetClass.superName;
        if (superClassName == null || superClassName.isEmpty()) {
            return;
        }
        if (superClassName.equals("java/lang/Object")) {
            return;
        }
        logger.debug("Creating calltree for superclass: " + superClassName);
        ClassNode superClass = DependencyAnalysis.getClassNode(superClassName);
        List methods = superClass.methods;
        for (MethodNode mn : methods) {
            logger.debug("Method: " + mn.name);
            if (mn.name.equals("<init>") || mn.name.equals("<clinit>") || (mn.access & 0x400) == 1024 || (mn.access & 1) != 1 || CallTreeGenerator.isOverridden(mn.name + mn.desc)) continue;
            CallTreeGenerator.handleMethodNode(callTree, superClass, mn, 0);
        }
        CallTreeGenerator.handleSuperClasses(callTree, superClass);
    }

    private static void handle(CallTree callTree, ClassNode targetClass, int depth) {
        List methods = targetClass.methods;
        for (MethodNode mn : methods) {
            logger.debug("Method: " + mn.name);
            CallTreeGenerator.handleMethodNode(callTree, targetClass, mn, depth);
        }
    }

    private static void handle(CallTree callTree, ClassNode targetClass, String methodName, int depth) {
        List methods = targetClass.methods;
        for (MethodNode mn : methods) {
            if (!methodName.equals(mn.name + mn.desc)) continue;
            CallTreeGenerator.handleMethodNode(callTree, targetClass, mn, depth);
        }
    }

    private static void handle(CallTree callTree, String className, String methodName, int depth) {
        ClassNode cn = DependencyAnalysis.getClassNode(className);
        if (cn == null) {
            return;
        }
        CallTreeGenerator.handle(callTree, cn, methodName, depth);
    }

    private static void handleMethodNode(CallTree callTree, ClassNode cn, MethodNode mn, int depth) {
        CallTreeGenerator.handlePublicMethodNode(callTree, cn, mn);
        InsnList instructions = mn.instructions;
        ListIterator iterator = instructions.iterator();
        while (iterator.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
            if (!(insn instanceof MethodInsnNode)) continue;
            CallTreeGenerator.handleMethodInsnNode(callTree, cn, mn, (MethodInsnNode)insn, depth + 1);
        }
    }

    private static void handlePublicMethodNode(CallTree callTree, ClassNode cn, MethodNode mn) {
        if ((mn.access & 1) == 1) {
            callTree.addPublicMethod(cn.name, mn.name + mn.desc);
        }
    }

    private static void handleMethodInsnNode(CallTree callTree, ClassNode cn, MethodNode mn, MethodInsnNode methodCall, int depth) {
        if (BytecodeInstrumentation.checkIfCanInstrument(methodCall.owner.replaceAll("/", "."))) {
            logger.debug("Handling method: " + methodCall.name);
            if (!callTree.hasCall(cn.name, mn.name + mn.desc, methodCall.owner, methodCall.name + methodCall.desc)) {
                callTree.addCall(cn.name, mn.name + mn.desc, methodCall.owner, methodCall.name + methodCall.desc);
                CallTreeGenerator.handle(callTree, methodCall.owner, methodCall.name + methodCall.desc, depth);
            }
        }
    }

    static void update(CallTree callTree, InheritanceTree inheritanceTree) {
        logger.info("Updating call tree ");
        LinkedHashSet<CallTreeEntry> subclassCalls = new LinkedHashSet<CallTreeEntry>();
        for (CallTreeEntry call : callTree) {
            String targetClass = call.getTargetClass();
            String targetMethod = call.getTargetMethod();
            if (targetMethod.startsWith("<init>") || targetClass.startsWith("[") || !inheritanceTree.hasClass(targetClass)) continue;
            for (String subclass : inheritanceTree.getSubclasses(targetClass)) {
                if (!inheritanceTree.isMethodDefined(subclass, targetMethod)) continue;
                subclassCalls.add(new CallTreeEntry(call.getSourceClass(), call.getSourceMethod(), subclass, targetMethod));
            }
        }
        callTree.addCalls(subclassCalls);
    }
}

