/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.evosuite.Properties;
import org.evosuite.runtime.FileSystemHandling;
import org.evosuite.runtime.Random;
import org.evosuite.runtime.System;
import org.evosuite.runtime.util.SystemInUtil;
import org.evosuite.runtime.vfs.VirtualFileSystem;
import org.evosuite.setup.TestCluster;
import org.evosuite.testcase.TestCase;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.GenericMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentTestClusterAugmenter {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentTestClusterAugmenter.class);
    private volatile boolean hasAddedRandom;
    private volatile boolean hasAddedSystem;
    private volatile boolean hasAddedFiles;
    private volatile boolean hasAddedSystemIn;
    private final TestCluster cluster;

    public EnvironmentTestClusterAugmenter(TestCluster cluster) {
        this.cluster = cluster;
    }

    public void handleRuntimeAccesses(TestCase test) {
        if (Properties.REPLACE_CALLS) {
            this.handleReplaceCalls();
        }
        if (Properties.VIRTUAL_FS) {
            this.handleVirtualFS(test);
        }
        if (Properties.REPLACE_SYSTEM_IN) {
            this.handleSystemIn();
        }
    }

    private void handleSystemIn() {
        if (!this.hasAddedSystemIn && SystemInUtil.getInstance().hasBeenUsed()) {
            this.hasAddedSystemIn = true;
            try {
                TestCluster.getInstance().addTestCall(new GenericMethod(SystemInUtil.class.getMethod("addInputLine", String.class), new GenericClass(SystemInUtil.class)));
            }
            catch (SecurityException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
        }
    }

    private void handleVirtualFS(TestCase test) {
        test.setAccessedFiles(new ArrayList<String>(VirtualFileSystem.getInstance().getAccessedFiles()));
        if (!this.hasAddedFiles && VirtualFileSystem.getInstance().getAccessedFiles().size() > 0) {
            logger.info("Adding EvoSuiteFile calls to cluster");
            this.hasAddedFiles = true;
            try {
                for (Method m : FileSystemHandling.class.getMethods()) {
                    this.cluster.addTestCall(new GenericMethod(m, new GenericClass(FileSystemHandling.class)));
                }
            }
            catch (Exception e) {
                logger.error("Error while handling virtual file system: " + e.getMessage(), e);
            }
        }
    }

    private void handleReplaceCalls() {
        if (!this.hasAddedRandom && Random.wasAccessed()) {
            this.hasAddedRandom = true;
            try {
                this.cluster.addTestCall(new GenericMethod(Random.class.getMethod("setNextRandom", Integer.TYPE), new GenericClass(Random.class)));
            }
            catch (SecurityException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
        }
        if (!this.hasAddedSystem && System.wasTimeAccessed()) {
            this.hasAddedSystem = true;
            try {
                this.cluster.addTestCall(new GenericMethod(System.class.getMethod("setCurrentTimeMillis", Long.TYPE), new GenericClass(System.class)));
            }
            catch (SecurityException e) {
                logger.error("Error while handling System: " + e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                logger.error("Error while handling System: " + e.getMessage(), e);
            }
        }
    }
}

