/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.setup.StaticFieldReadEntry;
import org.evosuite.setup.StaticMethodCallEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetStaticGraph {
    private static final Logger logger = LoggerFactory.getLogger(GetStaticGraph.class);
    private final Set<StaticFieldReadEntry> staticFieldReads = new HashSet<StaticFieldReadEntry>();
    private final Set<StaticMethodCallEntry> staticMethodCalls = new HashSet<StaticMethodCallEntry>();

    GetStaticGraph() {
    }

    public boolean hasStaticMethodCall(String owner, String methodName, String targetClass, String targetMethod) {
        StaticMethodCallEntry call = new StaticMethodCallEntry(owner, methodName, targetClass, targetMethod);
        return this.staticMethodCalls.contains(call);
    }

    public void addStaticMethodCall(String owner, String methodName, String targetClass, String targetMethod) {
        StaticMethodCallEntry call = new StaticMethodCallEntry(owner, methodName, targetClass, targetMethod);
        logger.info("Adding new static method call: " + call.toString());
        this.staticMethodCalls.add(call);
    }

    public boolean hasStaticFieldRead(String owner, String methodName, String targetClass, String targetField) {
        StaticFieldReadEntry read = new StaticFieldReadEntry(owner, methodName, targetClass, targetField);
        return this.staticFieldReads.contains(read);
    }

    public void addStaticFieldRead(String owner, String methodName, String targetClass, String targetField) {
        StaticFieldReadEntry read = new StaticFieldReadEntry(owner, methodName, targetClass, targetField);
        logger.info("Adding new static field read: " + read.toString());
        this.staticFieldReads.add(read);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.staticFieldReads == null ? 0 : this.staticFieldReads.hashCode());
        result = 31 * result + (this.staticMethodCalls == null ? 0 : this.staticMethodCalls.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetStaticGraph other = (GetStaticGraph)obj;
        if (this.staticFieldReads == null ? other.staticFieldReads != null : !this.staticFieldReads.equals(other.staticFieldReads)) {
            return false;
        }
        return !(this.staticMethodCalls == null ? other.staticMethodCalls != null : !this.staticMethodCalls.equals(other.staticMethodCalls));
    }

    public Set<String> getSourceClasses() {
        HashSet<String> sourceClasses = new HashSet<String>();
        for (StaticFieldReadEntry staticFieldReadEntry : this.staticFieldReads) {
            sourceClasses.add(staticFieldReadEntry.getSourceClass().replace("/", "."));
        }
        for (StaticMethodCallEntry staticMethodCallEntry : this.staticMethodCalls) {
            sourceClasses.add(staticMethodCallEntry.getSourceClass().replace("/", "."));
        }
        return sourceClasses;
    }

    public Set<String> getTargetClasses() {
        HashSet<String> targetClasses = new HashSet<String>();
        for (StaticFieldReadEntry staticFieldReadEntry : this.staticFieldReads) {
            targetClasses.add(staticFieldReadEntry.getTargetClass().replace("/", "."));
        }
        for (StaticMethodCallEntry staticMethodCallEntry : this.staticMethodCalls) {
            targetClasses.add(staticMethodCallEntry.getTargetClass().replace("/", "."));
        }
        return targetClasses;
    }

    public Map<String, Set<String>> getStaticFields() {
        HashMap<String, Set<String>> staticFields = new HashMap<String, Set<String>>();
        for (StaticFieldReadEntry read : this.staticFieldReads) {
            String className = read.getTargetClass().replace("/", ".");
            if (!staticFields.containsKey(className)) {
                staticFields.put(className, new HashSet());
            }
            ((Set)staticFields.get(className)).add(read.getTargetField());
        }
        return staticFields;
    }
}

