/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.classpath.ResourceList;
import org.evosuite.utils.LoggingUtils;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.graph.EdgeReversedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;

public class InheritanceTree {
    private final Map<String, Set<String>> subclassCache = new LinkedHashMap<String, Set<String>>();
    private DirectedMultigraph<String, DefaultEdge> inheritanceGraph = new DirectedMultigraph(DefaultEdge.class);

    public boolean isMethodDefined(String className, String methodName) {
        return false;
    }

    public void addSuperclass(String className, String superName, int access) {
        String classNameWithDots = ResourceList.getClassNameFromResourcePath(className);
        String superNameWithDots = ResourceList.getClassNameFromResourcePath(superName);
        if (this.inheritanceGraph == null) {
            this.inheritanceGraph = new DirectedMultigraph(DefaultEdge.class);
        }
        this.inheritanceGraph.addVertex(classNameWithDots);
        this.inheritanceGraph.addVertex(superNameWithDots);
        this.inheritanceGraph.addEdge(superNameWithDots, classNameWithDots);
    }

    public void addInterface(String className, String interfaceName) {
        String classNameWithDots = ResourceList.getClassNameFromResourcePath(className);
        String interfaceNameWithDots = ResourceList.getClassNameFromResourcePath(interfaceName);
        this.inheritanceGraph.addVertex(classNameWithDots);
        this.inheritanceGraph.addVertex(interfaceNameWithDots);
        this.inheritanceGraph.addEdge(interfaceNameWithDots, classNameWithDots);
    }

    public Set<String> getSubclasses(String className) {
        String classNameWithDots = ResourceList.getClassNameFromResourcePath(className);
        if (this.subclassCache.containsKey(classNameWithDots)) {
            return this.subclassCache.get(classNameWithDots);
        }
        if (!this.inheritanceGraph.containsVertex(classNameWithDots)) {
            LoggingUtils.getEvoLogger().warn("Class not in inheritance graph: " + classNameWithDots);
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        BreadthFirstIterator<String, DefaultEdge> bfi = new BreadthFirstIterator<String, DefaultEdge>(this.inheritanceGraph, classNameWithDots);
        while (bfi.hasNext()) {
            result.add((String)bfi.next());
        }
        this.subclassCache.put(classNameWithDots, result);
        return result;
    }

    public Set<String> getSuperclasses(String className) {
        String classNameWithDots = ResourceList.getClassNameFromResourcePath(className);
        EdgeReversedGraph<String, DefaultEdge> reverseGraph = new EdgeReversedGraph<String, DefaultEdge>((DirectedGraph<String, DefaultEdge>)this.inheritanceGraph);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        BreadthFirstIterator<String, DefaultEdge> bfi = new BreadthFirstIterator<String, DefaultEdge>(reverseGraph, classNameWithDots);
        while (bfi.hasNext()) {
            result.add((String)bfi.next());
        }
        return result;
    }

    public Set<String> getAllClasses() {
        return this.inheritanceGraph.vertexSet();
    }

    public void removeClass(String className) {
        this.inheritanceGraph.removeVertex(className);
    }

    public boolean hasClass(String className) {
        return this.inheritanceGraph.containsVertex(className);
    }

    public int getNumClasses() {
        return this.inheritanceGraph.vertexSet().size();
    }
}

