/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.GetStaticGraph;
import org.evosuite.setup.GetStaticGraphGenerator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class PutStaticMethodCollector {
    private static final String CLINIT = "<clinit>";
    private final Map<String, Set<String>> getStaticFields;

    private static Map<String, Set<String>> createStaticFields(String targetClassName) {
        GetStaticGraph getStaticGraph = GetStaticGraphGenerator.generate(targetClassName);
        return getStaticGraph.getStaticFields();
    }

    public PutStaticMethodCollector(String targetClassName) {
        this(targetClassName, PutStaticMethodCollector.createStaticFields(targetClassName));
    }

    public PutStaticMethodCollector(String targetClassName, Map<String, Set<String>> getStaticFields) {
        this.getStaticFields = getStaticFields;
    }

    public Set<MethodIdentifier> collectMethods() {
        HashSet<MethodIdentifier> methods = new HashSet<MethodIdentifier>();
        for (String calledClassName : this.getStaticFields.keySet()) {
            ClassNode classNode = DependencyAnalysis.getClassNode(calledClassName);
            List classMethods = classNode.methods;
            for (MethodNode mn : classMethods) {
                if (mn.name.equals(CLINIT)) continue;
                InsnList instructions = mn.instructions;
                ListIterator it = instructions.iterator();
                while (it.hasNext()) {
                    String calleeFieldName;
                    String calleeClassName;
                    FieldInsnNode fieldInsn;
                    AbstractInsnNode insn = (AbstractInsnNode)it.next();
                    if (!(insn instanceof FieldInsnNode) || (fieldInsn = (FieldInsnNode)insn).getOpcode() != 179 || !this.contains(this.getStaticFields, calleeClassName = fieldInsn.owner.replaceAll("/", "."), calleeFieldName = fieldInsn.name)) continue;
                    MethodIdentifier methodIdentifier = new MethodIdentifier(calledClassName, mn.name, mn.desc);
                    methods.add(methodIdentifier);
                }
            }
        }
        return methods;
    }

    private boolean contains(Map<String, Set<String>> fields, String className, String fieldName) {
        if (!fields.containsKey(className)) {
            return false;
        }
        return fields.get(className).contains(fieldName);
    }

    public static class MethodIdentifier {
        private final String className;
        private final String methodName;
        private final String desc;

        public MethodIdentifier(String className, String methodName, String desc) {
            this.className = className;
            this.methodName = methodName;
            this.desc = desc;
        }

        public String toString() {
            return this.className + "." + this.methodName + this.desc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
            result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodIdentifier other = (MethodIdentifier)obj;
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
                return false;
            }
            return !(this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName));
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

