/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.TimeController;
import org.evosuite.annotation.EvoSuiteExclude;
import org.evosuite.classpath.ResourceList;
import org.evosuite.graphs.GraphPool;
import org.evosuite.instrumentation.BooleanTestabilityTransformation;
import org.evosuite.rmi.ClientServices;
import org.evosuite.runtime.mock.MockList;
import org.evosuite.seeding.CastClassAnalyzer;
import org.evosuite.seeding.CastClassManager;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.setup.CallTree;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.GetStaticGraph;
import org.evosuite.setup.GetStaticGraphGenerator;
import org.evosuite.setup.InheritanceTree;
import org.evosuite.setup.PutStaticMethodCollector;
import org.evosuite.setup.TestCluster;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.GenericAccessibleObject;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.GenericConstructor;
import org.evosuite.utils.GenericField;
import org.evosuite.utils.GenericMethod;
import org.junit.Test;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClusterGenerator {
    private static Logger logger = LoggerFactory.getLogger(TestClusterGenerator.class);
    private static final List<String> classExceptions = Collections.unmodifiableList(Arrays.asList("com.apple", "apple.", "sun.", "com.sun.", "com.oracle.", "sun.awt."));
    private final Set<GenericAccessibleObject<?>> dependencyCache = new LinkedHashSet();
    private static final Map<Class<?>, Set<Method>> methodCache = new HashMap();
    private final Set<GenericClass> genericCastClasses = new LinkedHashSet<GenericClass>();
    private final Set<Class<?>> concreteCastClasses = new LinkedHashSet();
    private final Set<Class<?>> containerClasses = new LinkedHashSet();
    private static final Pattern ANONYMOUS_MATCHER1 = Pattern.compile(".*\\$\\d+.*$");
    private static final Pattern ANONYMOUS_MATCHER2 = Pattern.compile(".*\\.\\d+.*$");
    private final Set<Class<?>> analyzedClasses = new LinkedHashSet();
    private final Set<Pair> dependencies = new LinkedHashSet<Pair>();
    private InheritanceTree inheritanceTree = null;

    public static boolean checkIfCanUse(String className) {
        if (MockList.shouldBeMocked(className)) {
            return false;
        }
        for (String s : classExceptions) {
            if (!className.startsWith(s)) continue;
            return false;
        }
        return true;
    }

    public void generateCluster(String targetClass, InheritanceTree inheritanceTree, CallTree callTree) throws RuntimeException, ClassNotFoundException {
        this.inheritanceTree = inheritanceTree;
        TestCluster.setInheritanceTree(inheritanceTree);
        if (Properties.INSTRUMENT_CONTEXT || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE)) {
            for (String callTreeClass : DependencyAnalysis.getCallTree().getClasses()) {
                try {
                    TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(callTreeClass);
                }
                catch (ClassNotFoundException e) {
                    logger.info("Class not found: " + callTreeClass + ": " + e);
                }
            }
        }
        LinkedHashSet parameterClasses = new LinkedHashSet();
        LinkedHashSet callTreeClasses = new LinkedHashSet();
        parameterClasses.removeAll(callTreeClasses);
        LinkedHashSet<String> blackList = new LinkedHashSet<String>();
        this.initBlackListWithEvoSuitePrimitives(blackList);
        logger.info("Handling cast classes");
        this.handleCastClasses();
        logger.info("Initialising target class");
        this.initializeTargetMethods();
        logger.info("Resolving dependencies");
        this.resolveDependencies(blackList);
        if (logger.isDebugEnabled()) {
            logger.debug(TestCluster.getInstance().toString());
        }
        this.dependencyCache.clear();
        this.gatherStatistics();
    }

    private void handleCastClasses() {
        if (Properties.SEED_TYPES) {
            LinkedHashSet<String> blackList = new LinkedHashSet<String>();
            this.initBlackListWithPrimitives(blackList);
            LinkedHashSet<String> classNames = new LinkedHashSet<String>();
            CastClassAnalyzer analyzer = new CastClassAnalyzer();
            Map<org.objectweb.asm.Type, Integer> castMap = analyzer.analyze(Properties.TARGET_CLASS);
            for (Map.Entry<org.objectweb.asm.Type, Integer> castEntry : castMap.entrySet()) {
                String className = castEntry.getKey().getClassName();
                if (blackList.contains(className) || !this.addCastClassDependencyIfAccessible(className, blackList)) continue;
                CastClassManager.getInstance().addCastClass(className, (int)castEntry.getValue());
                classNames.add(castEntry.getKey().getClassName());
            }
            logger.debug("Cast classes used: " + classNames);
        }
    }

    private void gatherStatistics() {
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Analyzed_Classes, this.analyzedClasses.size());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Generators, TestCluster.getInstance().getGenerators().size());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Modifiers, TestCluster.getInstance().getModifiers().size());
    }

    private void initBlackListWithEvoSuitePrimitives(Set<String> blackList) throws NullPointerException {
        blackList.add("int");
        blackList.add("short");
        blackList.add("float");
        blackList.add("double");
        blackList.add("byte");
        blackList.add("char");
        blackList.add("boolean");
        blackList.add("long");
        blackList.add("java.lang.Enum");
        blackList.add("java.lang.String");
        blackList.add("java.lang.Class");
    }

    private void initBlackListWithPrimitives(Set<String> blackList) throws NullPointerException {
        blackList.add("int");
        blackList.add("short");
        blackList.add("float");
        blackList.add("double");
        blackList.add("byte");
        blackList.add("char");
        blackList.add("boolean");
        blackList.add("long");
    }

    private boolean addCastClassDependencyIfAccessible(String className, Set<String> blackList) {
        if (className.equals("java.lang.String")) {
            return true;
        }
        if (blackList.contains(className)) {
            logger.info("Cast class in blacklist: " + className);
            return false;
        }
        try {
            Class<?> clazz = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(className);
            if (!TestClusterGenerator.canUse(clazz)) {
                logger.debug("Cannot use cast class: " + className);
                return false;
            }
            this.addDependency(new GenericClass(clazz), 1);
            this.genericCastClasses.add(new GenericClass(clazz));
            this.concreteCastClasses.add(clazz);
            blackList.add(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.error("Problem for " + Properties.TARGET_CLASS + ". Class not found", e);
            blackList.add(className);
            return false;
        }
    }

    public void addCastClassForContainer(Class<?> clazz) {
        if (this.concreteCastClasses.contains(clazz)) {
            return;
        }
        this.concreteCastClasses.add(clazz);
        this.genericCastClasses.add(new GenericClass(clazz));
        CastClassManager.getInstance().addCastClass(clazz, 1);
        TestCluster.getInstance().clearGeneratorCache(new GenericClass(clazz));
    }

    private void resolveDependencies(Set<String> blackList) {
        while (!this.dependencies.isEmpty() && TimeController.getInstance().isThereStillTimeInThisPhase()) {
            String className;
            logger.debug("Dependencies left: " + this.dependencies.size());
            Iterator<Pair> iterator = this.dependencies.iterator();
            Pair dependency = iterator.next();
            iterator.remove();
            if (this.analyzedClasses.contains(dependency.getDependencyClass().getRawClass()) || blackList.contains(className = dependency.getDependencyClass().getClassName())) continue;
            boolean added = false;
            added = this.addDependencyClass(dependency.getDependencyClass(), dependency.getRecursion());
            if (added) continue;
            blackList.add(className);
        }
    }

    public List<List<GenericClass>> getAssignableTypes(GenericClass clazz) {
        ArrayList<List<GenericClass>> tuples = new ArrayList<List<GenericClass>>();
        boolean first = true;
        for (Type parameterType : clazz.getParameterTypes()) {
            List<GenericClass> assignableClasses = this.getAssignableTypes(parameterType);
            ArrayList newTuples = new ArrayList();
            for (GenericClass concreteClass : assignableClasses) {
                if (first) {
                    ArrayList<GenericClass> tuple = new ArrayList<GenericClass>();
                    tuple.add(concreteClass);
                    newTuples.add(tuple);
                    continue;
                }
                for (List list : tuples) {
                    ArrayList<GenericClass> tuple = new ArrayList<GenericClass>(list);
                    tuple.add(concreteClass);
                    newTuples.add(tuple);
                }
            }
            tuples = newTuples;
            first = false;
        }
        return tuples;
    }

    private List<GenericClass> getAssignableTypes(Type type) {
        ArrayList<GenericClass> types = new ArrayList<GenericClass>();
        for (GenericClass clazz : this.genericCastClasses) {
            if (!clazz.isAssignableTo(type)) continue;
            logger.debug(clazz + " is assignable to " + type);
            types.add(clazz);
        }
        return types;
    }

    private void addDeclaredClasses(Set<Class<?>> targetClasses, Class<?> currentClass) {
        for (Class<?> c : currentClass.getDeclaredClasses()) {
            logger.info("Adding declared class " + c);
            targetClasses.add(c);
            this.addDeclaredClasses(targetClasses, c);
        }
    }

    private void initializeTargetMethods() throws RuntimeException, ClassNotFoundException {
        logger.info("Analyzing target class");
        Class<?> targetClass = Properties.getTargetClass();
        TestCluster cluster = TestCluster.getInstance();
        LinkedHashSet targetClasses = new LinkedHashSet();
        if (targetClass == null) {
            throw new RuntimeException("Failed to load " + Properties.TARGET_CLASS);
        }
        targetClasses.add(targetClass);
        this.addDeclaredClasses(targetClasses, targetClass);
        if (Modifier.isAbstract(targetClass.getModifiers())) {
            logger.info("SUT is an abstract class");
            Set<Class<?>> subclasses = TestClusterGenerator.getConcreteClasses(targetClass, this.inheritanceTree);
            logger.info("Found " + subclasses.size() + " concrete subclasses");
            targetClasses.addAll(subclasses);
        }
        ClassNode targetClassNode = DependencyAnalysis.getClassNode(Properties.TARGET_CLASS);
        LinkedList innerClasses = new LinkedList();
        innerClasses.addAll(targetClassNode.innerClasses);
        while (!innerClasses.isEmpty()) {
            InnerClassNode icn = (InnerClassNode)innerClasses.poll();
            try {
                logger.debug("Loading inner class: " + icn.innerName + ", " + icn.name + "," + icn.outerName);
                String string = ResourceList.getClassNameFromResourcePath(icn.name);
                Class<?> innerClass = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(string);
                if (targetClasses.contains(innerClass)) continue;
                logger.info("Adding inner class " + string);
                targetClasses.add(innerClass);
                ClassNode classNode = DependencyAnalysis.getClassNode(string);
                innerClasses.addAll(classNode.innerClasses);
            }
            catch (Throwable throwable) {
                logger.error("Problem for " + Properties.TARGET_CLASS + ". Error loading inner class: " + icn.innerName + ", " + icn.name + "," + icn.outerName + ": " + throwable);
            }
        }
        for (Class clazz : targetClasses) {
            String orig;
            String name;
            logger.info("Current SUT class: " + clazz);
            if (!TestClusterGenerator.canUse(clazz)) {
                logger.info("Cannot access SUT class: " + clazz);
                continue;
            }
            for (Constructor constructor : TestClusterGenerator.getConstructors(clazz)) {
                logger.info("Checking target constructor " + constructor);
                name = "<init>" + org.objectweb.asm.Type.getConstructorDescriptor(constructor);
                if (Properties.TT && !(orig = name).equals(name = BooleanTestabilityTransformation.getOriginalNameDesc(clazz.getName(), "<init>", org.objectweb.asm.Type.getConstructorDescriptor(constructor)))) {
                    logger.info("TT name: " + orig + " -> " + name);
                }
                if (TestClusterGenerator.canUse(constructor)) {
                    GenericConstructor genericConstructor = new GenericConstructor(constructor, clazz);
                    cluster.addTestCall(genericConstructor);
                    cluster.addGenerator(new GenericClass(clazz), genericConstructor);
                    this.addDependencies(genericConstructor, 1);
                    logger.debug("Keeping track of " + constructor.getDeclaringClass().getName() + "." + constructor.getName() + org.objectweb.asm.Type.getConstructorDescriptor(constructor));
                    continue;
                }
                logger.debug("Constructor cannot be used: " + constructor);
            }
            for (Method method : TestClusterGenerator.getMethods(clazz)) {
                logger.info("Checking target method " + method);
                name = method.getName() + org.objectweb.asm.Type.getMethodDescriptor(method);
                if (Properties.TT && !(orig = name).equals(name = BooleanTestabilityTransformation.getOriginalNameDesc(clazz.getName(), method.getName(), org.objectweb.asm.Type.getMethodDescriptor(method)))) {
                    logger.info("TT name: " + orig + " -> " + name);
                }
                if (TestClusterGenerator.canUse(method, clazz)) {
                    logger.debug("Adding method " + clazz.getName() + "." + method.getName() + org.objectweb.asm.Type.getMethodDescriptor(method));
                    GenericMethod genericMethod = new GenericMethod(method, clazz);
                    cluster.addTestCall(genericMethod);
                    cluster.addModifier(new GenericClass(clazz), genericMethod);
                    this.addDependencies(genericMethod, 1);
                    GenericClass retClass = new GenericClass(method.getReturnType());
                    if (retClass.isPrimitive() || retClass.isVoid() || retClass.isObject()) continue;
                    cluster.addGenerator(retClass, genericMethod);
                    continue;
                }
                logger.debug("Method cannot be used: " + method);
            }
            for (Field field : TestClusterGenerator.getFields(clazz)) {
                logger.info("Checking target field " + field);
                if (TestClusterGenerator.canUse(field, clazz)) {
                    GenericField genericField = new GenericField(field, clazz);
                    this.addDependencies(genericField, 1);
                    cluster.addGenerator(new GenericClass(field.getGenericType()), genericField);
                    logger.debug("Adding field " + field);
                    if (!Modifier.isFinal(field.getModifiers())) {
                        logger.debug("Is not final");
                        cluster.addTestCall(new GenericField(field, clazz));
                        continue;
                    }
                    logger.debug("Is final");
                    if (!Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive()) continue;
                    logger.debug("Is static non-primitive");
                    try {
                        Object o = field.get(null);
                        if (o == null) {
                            logger.info("Field is not yet initialized: " + field);
                            continue;
                        }
                        Class<?> actualClass = o.getClass();
                        logger.debug("Actual class is " + actualClass);
                        if (actualClass.isAssignableFrom(genericField.getRawGeneratedType()) || !genericField.getRawGeneratedType().isAssignableFrom(actualClass)) continue;
                        GenericField superClassField = new GenericField(field, clazz);
                        cluster.addGenerator(new GenericClass(actualClass), superClassField);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                logger.debug("Can't use field " + field);
            }
            this.analyzedClasses.add(clazz);
            cluster.getAnalyzedClasses().add(clazz);
        }
        if (Properties.INSTRUMENT_PARENT) {
            for (String string : this.inheritanceTree.getSuperclasses(Properties.TARGET_CLASS)) {
                try {
                    Class<?> superClazz = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(string);
                    this.dependencies.add(new Pair(0, superClazz));
                }
                catch (ClassNotFoundException e) {
                    logger.error("Problem for " + Properties.TARGET_CLASS + ". Class not found: " + string, e);
                }
            }
        }
        if (Properties.HANDLE_STATIC_FIELDS) {
            GetStaticGraph getStaticGraph = GetStaticGraphGenerator.generate(Properties.TARGET_CLASS);
            Map<String, Set<String>> map = getStaticGraph.getStaticFields();
            for (String string : map.keySet()) {
                Class<?> clazz;
                logger.info("Adding static fields to cluster for class " + string);
                try {
                    clazz = this.getClass(string);
                }
                catch (ExceptionInInitializerError ex) {
                    logger.debug("Class class init caused exception " + string);
                    continue;
                }
                if (clazz == null) {
                    logger.debug("Class not found " + string);
                    continue;
                }
                if (!TestClusterGenerator.canUse(clazz)) continue;
                Set<String> fields = map.get(string);
                for (Field field : TestClusterGenerator.getFields(clazz)) {
                    if (!TestClusterGenerator.canUse(field, clazz) || !fields.contains(field.getName()) || Modifier.isFinal(field.getModifiers())) continue;
                    logger.debug("Is not final");
                    cluster.addTestCall(new GenericField(field, clazz));
                }
            }
            PutStaticMethodCollector collector = new PutStaticMethodCollector(Properties.TARGET_CLASS, map);
            Set<PutStaticMethodCollector.MethodIdentifier> set = collector.collectMethods();
            for (PutStaticMethodCollector.MethodIdentifier methodId : set) {
                Method method;
                Class<?> clazz = this.getClass(methodId.getClassName());
                if (clazz == null || !TestClusterGenerator.canUse(clazz) || (method = this.getMethod(clazz, methodId.getMethodName(), methodId.getDesc())) == null) continue;
                GenericMethod genericMethod = new GenericMethod(method, clazz);
                cluster.addTestCall(genericMethod);
            }
        }
        logger.info("Finished analyzing target class");
    }

    private Method getMethod(Class<?> clazz, String methodName, String desc) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName) || !org.objectweb.asm.Type.getMethodDescriptor(method).equals(desc)) continue;
            return method;
        }
        return null;
    }

    private Class<?> getClass(String className) {
        try {
            Class<?> clazz = Class.forName(className, true, TestGenerationContext.getInstance().getClassLoaderForSUT());
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    public static Set<Constructor<?>> getConstructors(Class<?> clazz) {
        TreeMap helper = new TreeMap();
        LinkedHashSet constructors = new LinkedHashSet();
        try {
            for (Constructor<?> c : clazz.getDeclaredConstructors()) {
                helper.put(org.objectweb.asm.Type.getConstructorDescriptor(c), c);
            }
        }
        catch (Throwable t) {
            logger.info("Error while analyzing class " + clazz + ": " + t);
        }
        for (Constructor c : helper.values()) {
            constructors.add(c);
        }
        return constructors;
    }

    public static Set<Method> getMethods(Class<?> clazz) {
        if (methodCache.containsKey(clazz)) {
            return methodCache.get(clazz);
        }
        TreeMap<String, GenericDeclaration> helper = new TreeMap<String, GenericDeclaration>();
        if (clazz.getSuperclass() != null) {
            for (Method m : TestClusterGenerator.getMethods(clazz.getSuperclass())) {
                helper.put(m.getName() + org.objectweb.asm.Type.getMethodDescriptor(m), m);
            }
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            for (Method m : TestClusterGenerator.getMethods(clazz2)) {
                helper.put(m.getName() + org.objectweb.asm.Type.getMethodDescriptor(m), m);
            }
        }
        try {
            for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
                helper.put(((Method)genericDeclaration).getName() + org.objectweb.asm.Type.getMethodDescriptor((Method)genericDeclaration), genericDeclaration);
            }
        }
        catch (NoClassDefFoundError e) {
            logger.info("Error while trying to load methods of class " + clazz.getName() + ": " + e);
        }
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        methods.addAll(helper.values());
        methodCache.put(clazz, methods);
        return methods;
    }

    public static Set<Field> getFields(Class<?> clazz) {
        TreeMap<String, AnnotatedElement> helper = new TreeMap<String, AnnotatedElement>();
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        if (clazz.getSuperclass() != null) {
            for (Field f : TestClusterGenerator.getFields(clazz.getSuperclass())) {
                helper.put(f.toGenericString(), f);
            }
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            for (Field f : TestClusterGenerator.getFields(clazz2)) {
                helper.put(f.toGenericString(), f);
            }
        }
        try {
            for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
                helper.put(((Field)annotatedElement).toGenericString(), annotatedElement);
            }
        }
        catch (NoClassDefFoundError e) {
            logger.info("Error while trying to load fields of class " + clazz.getName() + ": " + e);
        }
        fields.addAll(helper.values());
        return fields;
    }

    public static Set<Field> getAccessibleFields(Class<?> clazz) {
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        try {
            for (Field f : clazz.getFields()) {
                if (!TestClusterGenerator.canUse(f) || Modifier.isFinal(f.getModifiers())) continue;
                fields.add(f);
            }
        }
        catch (Throwable t) {
            logger.info("Error while accessing fields of class " + clazz.getName() + " - check allowed permissions: " + t);
        }
        return fields;
    }

    private static boolean isEvoSuiteClass(Class<?> c) {
        return c.getName().startsWith("org.evosuite");
    }

    protected static void makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
    }

    protected static void makeAccessible(Method method) {
        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
    }

    protected static void makeAccessible(Constructor<?> constructor) {
        if (!Modifier.isPublic(constructor.getModifiers()) || !Modifier.isPublic(constructor.getDeclaringClass().getModifiers())) {
            constructor.setAccessible(true);
        }
    }

    public static boolean canUse(Type t) {
        if (t instanceof Class) {
            return TestClusterGenerator.canUse((Class)t);
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            for (Type parameterType : pt.getActualTypeArguments()) {
                if (TestClusterGenerator.canUse(parameterType)) continue;
                return false;
            }
            if (!TestClusterGenerator.canUse(pt.getOwnerType())) {
                return false;
            }
        }
        return true;
    }

    public static boolean canUse(Class<?> c) {
        String packageName;
        if (Modifier.isPrivate(c.getModifiers())) {
            return false;
        }
        if (!Properties.USE_DEPRECATED && c.isAnnotationPresent(Deprecated.class)) {
            logger.debug("Skipping deprecated class " + c.getName());
            return false;
        }
        if (c.isAnonymousClass()) {
            return false;
        }
        if (ANONYMOUS_MATCHER1.matcher(c.getName()).matches()) {
            logger.debug(c + " looks like an anonymous class, ignoring it (although reflection says " + c.isAnonymousClass() + ")");
            return false;
        }
        if (ANONYMOUS_MATCHER2.matcher(c.getName()).matches()) {
            logger.debug(c + " looks like an anonymous class, ignoring it (although reflection says " + c.isAnonymousClass() + ")");
            return false;
        }
        if (c.getName().startsWith("junit")) {
            return false;
        }
        if (TestClusterGenerator.isEvoSuiteClass(c) && !MockList.isAMockClass(c.getCanonicalName())) {
            return false;
        }
        if (c.getEnclosingClass() != null && !TestClusterGenerator.canUse(c.getEnclosingClass())) {
            return false;
        }
        if (c.getDeclaringClass() != null && !TestClusterGenerator.canUse(c.getDeclaringClass())) {
            return false;
        }
        if (!(c.isArray() || c.isPrimitive() || Properties.CLASS_PREFIX.isEmpty() || c.getName().contains("."))) {
            return false;
        }
        if (Modifier.isPublic(c.getModifiers())) {
            return true;
        }
        if (!Modifier.isPrivate(c.getModifiers()) && (packageName = ClassUtils.getPackageName(c)).equals(Properties.CLASS_PREFIX)) {
            return true;
        }
        logger.debug("Not public");
        return false;
    }

    public static boolean canUse(Field f) {
        return TestClusterGenerator.canUse(f, f.getDeclaringClass());
    }

    public static boolean canUse(Field f, Class<?> ownerClass) {
        if (f.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        if (f.getDeclaringClass().equals(Thread.class)) {
            return false;
        }
        if (!Properties.USE_DEPRECATED && f.isAnnotationPresent(Deprecated.class)) {
            logger.debug("Skipping deprecated field " + f.getName());
            return false;
        }
        if (f.isSynthetic()) {
            logger.debug("Skipping synthetic field " + f.getName());
            return false;
        }
        if (f.getName().startsWith("ajc$")) {
            logger.debug("Skipping AspectJ field " + f.getName());
            return false;
        }
        if (!f.getType().equals(String.class) && !TestClusterGenerator.canUse(f.getType())) {
            return false;
        }
        if (Modifier.isPublic(f.getModifiers())) {
            TestClusterGenerator.makeAccessible(f);
            return true;
        }
        if (!Modifier.isPrivate(f.getModifiers())) {
            String packageName = ClassUtils.getPackageName(ownerClass);
            String declaredPackageName = ClassUtils.getPackageName(f.getDeclaringClass());
            if (packageName.equals(Properties.CLASS_PREFIX) && packageName.equals(declaredPackageName)) {
                TestClusterGenerator.makeAccessible(f);
                return true;
            }
        }
        return false;
    }

    public static boolean canUse(Method m) {
        return TestClusterGenerator.canUse(m, m.getDeclaringClass());
    }

    public static boolean canUse(Method m, Class<?> ownerClass) {
        if (m.isBridge()) {
            logger.debug("Excluding bridge method: " + m.toString());
            return false;
        }
        if (m.isSynthetic()) {
            logger.debug("Excluding synthetic method: " + m.toString());
            return false;
        }
        if (!Properties.USE_DEPRECATED && m.isAnnotationPresent(Deprecated.class)) {
            logger.debug("Excluding deprecated method " + m.getName());
            return false;
        }
        if (m.isAnnotationPresent(Test.class)) {
            logger.debug("Excluding test method " + m.getName());
            return false;
        }
        if (m.isAnnotationPresent(EvoSuiteExclude.class)) {
            logger.debug("Excluding method with exclusion annotation " + m.getName());
            return false;
        }
        logger.debug("Method has no exclusion annotation " + m.getName());
        for (Annotation a : m.getDeclaredAnnotations()) {
            logger.debug("1 Has annotation: " + a);
        }
        for (Annotation a : m.getAnnotations()) {
            logger.debug("2 Has annotation: " + a);
        }
        if (m.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        if (!m.getReturnType().equals(String.class) && !TestClusterGenerator.canUse(m.getGenericReturnType())) {
            return false;
        }
        if (m.getDeclaringClass().equals(Enum.class)) {
            return false;
        }
        if (m.getDeclaringClass().equals(Thread.class)) {
            return false;
        }
        if (m.getName().equals("hashCode")) {
            if (!m.getDeclaringClass().equals(Properties.getTargetClass())) {
                return false;
            }
            if (GraphPool.getInstance(ownerClass.getClassLoader()).getActualCFG(Properties.TARGET_CLASS, m.getName() + org.objectweb.asm.Type.getMethodDescriptor(m)) == null) {
                return false;
            }
        }
        if (m.getName().equals("deepHashCode") && m.getDeclaringClass().equals(Arrays.class)) {
            return false;
        }
        if (m.getName().equals("getAvailableLocales")) {
            return false;
        }
        if (m.getName().equals("__STATIC_RESET")) {
            logger.debug("Ignoring static reset class");
            return false;
        }
        if (TestClusterGenerator.isForbiddenNonDeterministicCall(m)) {
            return false;
        }
        if (!Properties.CONSIDER_MAIN_METHODS && m.getName().equals("main") && Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers())) {
            logger.debug("Ignoring static main method ");
            return false;
        }
        if (Modifier.isPublic(m.getModifiers())) {
            TestClusterGenerator.makeAccessible(m);
            return true;
        }
        if (!Modifier.isPrivate(m.getModifiers())) {
            String packageName = ClassUtils.getPackageName(ownerClass);
            String declaredPackageName = ClassUtils.getPackageName(m.getDeclaringClass());
            if (packageName.equals(Properties.CLASS_PREFIX) && packageName.equals(declaredPackageName)) {
                TestClusterGenerator.makeAccessible(m);
                return true;
            }
        }
        return false;
    }

    private static boolean hasStaticGenerator(Class<?> clazz) {
        for (Method m : clazz.getMethods()) {
            if (!Modifier.isStatic(m.getModifiers()) || !clazz.isAssignableFrom(m.getReturnType())) continue;
            return true;
        }
        return false;
    }

    private static boolean isForbiddenNonDeterministicCall(Method m) {
        if (!Properties.REPLACE_CALLS) {
            return false;
        }
        Class<?> declaringClass = m.getDeclaringClass();
        if (declaringClass.equals(Calendar.class) && m.getName().equals("getInstance")) {
            return true;
        }
        if (declaringClass.equals(Locale.class)) {
            if (m.getName().equals("getDefault")) {
                return true;
            }
            if (m.getName().equals("getAvailableLocales")) {
                return true;
            }
        }
        if (declaringClass.equals(MessageFormat.class) && m.getName().equals("getLocale")) {
            return true;
        }
        return m.getDeclaringClass().equals(Date.class) && m.getName().equals("toLocaleString");
    }

    private static boolean isForbiddenNonDeterministicCall(Constructor<?> c) {
        if (!Properties.REPLACE_CALLS) {
            return false;
        }
        if (c.getDeclaringClass().equals(Date.class) && c.getParameterTypes().length == 0) {
            return true;
        }
        return c.getDeclaringClass().equals(Random.class) && c.getParameterTypes().length == 0;
    }

    public static boolean canUse(Constructor<?> c) {
        String packageName;
        if (c.isSynthetic()) {
            return false;
        }
        if (Modifier.isAbstract(c.getDeclaringClass().getModifiers())) {
            return false;
        }
        if (c.getDeclaringClass().equals(Thread.class)) {
            return false;
        }
        if (c.getDeclaringClass().isAnonymousClass()) {
            return false;
        }
        if (c.getDeclaringClass().isLocalClass()) {
            logger.debug("Skipping constructor of local class " + c.getName());
            return false;
        }
        if (c.getDeclaringClass().isMemberClass() && !TestClusterGenerator.canUse(c.getDeclaringClass())) {
            return false;
        }
        if (!Properties.USE_DEPRECATED && c.getAnnotation(Deprecated.class) != null) {
            logger.debug("Skipping deprecated constructor " + c.getName());
            return false;
        }
        if (TestClusterGenerator.isForbiddenNonDeterministicCall(c)) {
            return false;
        }
        if (Modifier.isPublic(c.getModifiers())) {
            TestClusterGenerator.makeAccessible(c);
            return true;
        }
        if (!Modifier.isPrivate(c.getModifiers()) && (packageName = ClassUtils.getPackageName(c.getDeclaringClass())).equals(Properties.CLASS_PREFIX)) {
            TestClusterGenerator.makeAccessible(c);
            return true;
        }
        return false;
    }

    private void addDependencies(GenericConstructor constructor, int recursionLevel) {
        if (recursionLevel > Properties.CLUSTER_RECURSION) {
            logger.debug("Maximum recursion level reached, not adding dependencies of {}", (Object)constructor);
            return;
        }
        if (this.dependencyCache.contains(constructor)) {
            return;
        }
        logger.debug("Analyzing dependencies of " + constructor);
        this.dependencyCache.add(constructor);
        for (Type parameterClass : constructor.getRawParameterTypes()) {
            logger.debug("Adding dependency " + parameterClass);
            this.addDependency(new GenericClass(parameterClass), recursionLevel);
        }
    }

    private void addDependencies(GenericMethod method, int recursionLevel) {
        if (recursionLevel > Properties.CLUSTER_RECURSION) {
            logger.debug("Maximum recursion level reached, not adding dependencies of {}", (Object)method);
            return;
        }
        if (this.dependencyCache.contains(method)) {
            return;
        }
        logger.debug("Analyzing dependencies of " + method);
        this.dependencyCache.add(method);
        for (Class<?> parameter : method.getRawParameterTypes()) {
            logger.debug("Current parameter " + parameter);
            GenericClass parameterClass = new GenericClass((Type)parameter);
            if (parameterClass.isPrimitive() || parameterClass.isString()) continue;
            logger.debug("Adding dependency " + parameterClass.getClassName());
            this.addDependency(parameterClass, recursionLevel);
        }
    }

    private void addDependencies(GenericField field, int recursionLevel) {
        if (recursionLevel > Properties.CLUSTER_RECURSION) {
            logger.debug("Maximum recursion level reached, not adding dependencies of {}", (Object)field);
            return;
        }
        if (this.dependencyCache.contains(field)) {
            return;
        }
        if (field.getField().getType().isPrimitive() || field.getField().getType().equals(String.class)) {
            return;
        }
        logger.debug("Analyzing dependencies of " + field);
        this.dependencyCache.add(field);
        logger.debug("Adding dependency " + field.getName());
        this.addDependency(new GenericClass(field.getGenericFieldType()), recursionLevel);
    }

    private void addDependency(GenericClass clazz, int recursionLevel) {
        if (this.analyzedClasses.contains((clazz = clazz.getRawGenericClass()).getRawClass())) {
            return;
        }
        if (clazz.isPrimitive()) {
            return;
        }
        if (clazz.isString()) {
            return;
        }
        if (clazz.getRawClass().equals(Enum.class)) {
            return;
        }
        if (clazz.isArray()) {
            this.addDependency(new GenericClass(clazz.getComponentType()), recursionLevel);
            return;
        }
        if (!TestClusterGenerator.canUse(clazz.getRawClass())) {
            return;
        }
        Class<?> mock = MockList.getMockClass(clazz.getRawClass().getCanonicalName());
        if (mock != null) {
            logger.debug("Adding mock " + mock + " instead of " + clazz);
            clazz = new GenericClass(mock);
        } else if (!TestClusterGenerator.checkIfCanUse(clazz.getClassName())) {
            return;
        }
        for (Pair pair : this.dependencies) {
            if (!pair.getDependencyClass().equals(clazz)) continue;
            return;
        }
        logger.debug("Getting concrete classes for " + clazz.getClassName());
        ConstantPoolManager.getInstance().addNonSUTConstant(org.objectweb.asm.Type.getType(clazz.getRawClass()));
        ArrayList actualClasses = new ArrayList(TestClusterGenerator.getConcreteClasses(clazz.getRawClass(), this.inheritanceTree));
        logger.debug("Concrete classes for " + clazz.getClassName() + ": " + actualClasses.size());
        for (Class clazz2 : actualClasses) {
            logger.debug("Adding concrete class: " + clazz2);
            this.dependencies.add(new Pair(recursionLevel, clazz2));
        }
    }

    private boolean addDependencyClass(GenericClass clazz, int recursionLevel) {
        if (recursionLevel > Properties.CLUSTER_RECURSION) {
            logger.debug("Maximum recursion level reached, not adding dependency {}", (Object)clazz.getClassName());
            return false;
        }
        if (this.analyzedClasses.contains((clazz = clazz.getRawGenericClass()).getRawClass())) {
            return true;
        }
        this.analyzedClasses.add(clazz.getRawClass());
        if ((clazz.isAssignableTo((Type)((Object)Collection.class)) || clazz.isAssignableTo((Type)((Object)Map.class))) && clazz.getNumParameters() > 0) {
            this.containerClasses.add(clazz.getRawClass());
        }
        if (clazz.isString()) {
            return false;
        }
        try {
            String orig;
            String name;
            TestCluster cluster = TestCluster.getInstance();
            logger.debug("Adding dependency class " + clazz.getClassName());
            if (!TestClusterGenerator.canUse(clazz.getRawClass())) {
                logger.info("*** Cannot use class: " + clazz.getClassName());
                return false;
            }
            for (Constructor<?> constructor : TestClusterGenerator.getConstructors(clazz.getRawClass())) {
                name = "<init>" + org.objectweb.asm.Type.getConstructorDescriptor(constructor);
                if (Properties.TT && !(orig = name).equals(name = BooleanTestabilityTransformation.getOriginalNameDesc(clazz.getClassName(), "<init>", org.objectweb.asm.Type.getConstructorDescriptor(constructor)))) {
                    logger.info("TT name: " + orig + " -> " + name);
                }
                if (TestClusterGenerator.canUse(constructor)) {
                    GenericConstructor genericConstructor = new GenericConstructor(constructor, clazz);
                    try {
                        cluster.addGenerator(clazz, genericConstructor);
                        this.addDependencies(genericConstructor, recursionLevel + 1);
                        logger.debug("Keeping track of " + constructor.getDeclaringClass().getName() + "." + constructor.getName() + org.objectweb.asm.Type.getConstructorDescriptor(constructor));
                    }
                    catch (Throwable t) {
                        logger.info("Error adding constructor " + constructor.getName() + ": " + t.getMessage());
                    }
                    continue;
                }
                logger.debug("Constructor cannot be used: " + constructor);
            }
            for (Method method : TestClusterGenerator.getMethods(clazz.getRawClass())) {
                name = method.getName() + org.objectweb.asm.Type.getMethodDescriptor(method);
                if (Properties.TT && !(orig = name).equals(name = BooleanTestabilityTransformation.getOriginalNameDesc(clazz.getClassName(), method.getName(), org.objectweb.asm.Type.getMethodDescriptor(method)))) {
                    logger.info("TT name: " + orig + " -> " + name);
                }
                if (TestClusterGenerator.canUse(method, clazz.getRawClass()) && !method.getName().equals("hashCode")) {
                    logger.debug("Adding method " + clazz.getClassName() + "." + method.getName() + org.objectweb.asm.Type.getMethodDescriptor(method));
                    logger.debug("HashCode: " + method.getName().equals("hashCode") + ", " + method.getName());
                    if (method.getTypeParameters().length > 0) {
                        logger.info("Type parameters in methods are not handled yet, skipping " + method);
                        continue;
                    }
                    GenericMethod genericMethod = new GenericMethod(method, clazz);
                    try {
                        this.addDependencies(genericMethod, recursionLevel + 1);
                        cluster.addModifier(clazz, genericMethod);
                        GenericClass retClass = new GenericClass(method.getReturnType());
                        if (retClass.isPrimitive() || retClass.isVoid() || retClass.isObject()) continue;
                        cluster.addGenerator(retClass, genericMethod);
                    }
                    catch (Throwable t) {
                        logger.info("Error adding method " + method.getName() + ": " + t.getMessage());
                    }
                    continue;
                }
                logger.debug("Method cannot be used: " + method);
            }
            for (Field field : TestClusterGenerator.getFields(clazz.getRawClass())) {
                logger.debug("Checking field " + field);
                if (TestClusterGenerator.canUse(field, clazz.getRawClass())) {
                    logger.debug("Adding field " + field + " for class " + clazz);
                    try {
                        GenericField genericField = new GenericField(field, clazz);
                        cluster.addGenerator(new GenericClass(field.getGenericType()), genericField);
                        if (Modifier.isFinal(field.getModifiers())) continue;
                        cluster.addModifier(clazz, genericField);
                        this.addDependencies(genericField, recursionLevel + 1);
                    }
                    catch (Throwable t) {
                        logger.info("Error adding field " + field.getName() + ": " + t.getMessage());
                    }
                    continue;
                }
                logger.debug("Field cannot be used: " + field);
            }
            logger.info("Finished analyzing " + clazz.getTypeName() + " at recursion level " + recursionLevel);
            cluster.getAnalyzedClasses().add(clazz.getRawClass());
        }
        catch (Throwable t) {
            logger.error("Problem for " + Properties.TARGET_CLASS + ". Failed to add dependencies for class " + clazz.getClassName() + ": " + t + "\n" + Arrays.asList(t.getStackTrace()));
            return false;
        }
        return true;
    }

    public static Set<Class<?>> getConcreteClasses(Class<?> clazz, InheritanceTree inheritanceTree) {
        if (clazz.equals(Map.class)) {
            return TestClusterGenerator.getConcreteClassesMap();
        }
        if (clazz.equals(List.class)) {
            return TestClusterGenerator.getConcreteClassesList();
        }
        if (clazz.equals(Set.class)) {
            return TestClusterGenerator.getConcreteClassesSet();
        }
        if (clazz.equals(Collection.class)) {
            return TestClusterGenerator.getConcreteClassesList();
        }
        if (clazz.equals(Iterator.class)) {
            return new LinkedHashSet();
        }
        if (clazz.equals(ListIterator.class)) {
            return new LinkedHashSet();
        }
        if (clazz.equals(Serializable.class)) {
            return new LinkedHashSet();
        }
        if (clazz.equals(Comparable.class)) {
            return TestClusterGenerator.getConcreteClassesComparable();
        }
        if (clazz.equals(Comparator.class)) {
            return new LinkedHashSet();
        }
        LinkedHashSet actualClasses = new LinkedHashSet();
        if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()) || clazz.equals(Enum.class)) {
            Set<String> subClasses = inheritanceTree.getSubclasses(clazz.getName());
            logger.debug("Subclasses of " + clazz.getName() + ": " + subClasses);
            HashMap<String, Integer> classDistance = new HashMap<String, Integer>();
            int maxDistance = -1;
            String name = clazz.getName();
            if (clazz.equals(Enum.class)) {
                name = Properties.TARGET_CLASS;
            }
            for (String subClass : subClasses) {
                int distance = TestClusterGenerator.getPackageDistance(subClass, name);
                classDistance.put(subClass, distance);
                maxDistance = Math.max(distance, maxDistance);
            }
            for (int distance = 0; actualClasses.isEmpty() && distance <= maxDistance; ++distance) {
                logger.debug(" Current distance: " + distance);
                for (String subClass : subClasses) {
                    if ((Integer)classDistance.get(subClass) != distance) continue;
                    try {
                        Class<?> subClazz = Class.forName(subClass, false, TestGenerationContext.getInstance().getClassLoaderForSUT());
                        if (!TestClusterGenerator.canUse(subClazz) || subClazz.isInterface() || Modifier.isAbstract(subClazz.getModifiers()) && !TestClusterGenerator.hasStaticGenerator(subClazz)) continue;
                        Class<?> mock = MockList.getMockClass(subClazz.getCanonicalName());
                        if (mock != null) {
                            logger.debug("Adding mock " + mock + " instead of " + clazz);
                            subClazz = mock;
                        } else if (!TestClusterGenerator.checkIfCanUse(subClazz.getCanonicalName())) continue;
                        actualClasses.add(subClazz);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("Problem for " + Properties.TARGET_CLASS + ". Class not found: " + subClass, e);
                        logger.error("Removing class from inheritance tree");
                        inheritanceTree.removeClass(subClass);
                    }
                }
            }
            if (TestClusterGenerator.hasStaticGenerator(clazz)) {
                actualClasses.add(clazz);
            }
            if (actualClasses.isEmpty()) {
                logger.info("Don't know how to instantiate abstract class " + clazz.getName());
            }
        } else {
            actualClasses.add(clazz);
        }
        logger.debug("Subclasses of " + clazz.getName() + ": " + actualClasses);
        return actualClasses;
    }

    private static Set<Class<?>> getConcreteClassesMap() {
        LinkedHashSet mapClasses = new LinkedHashSet();
        try {
            Class<?> mapClazz = Class.forName("java.util.HashMap", false, TestGenerationContext.getInstance().getClassLoaderForSUT());
            mapClasses.add(mapClazz);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return mapClasses;
    }

    private static Set<Class<?>> getConcreteClassesList() {
        LinkedHashSet mapClasses = new LinkedHashSet();
        try {
            Class<?> mapClazz = Class.forName("java.util.LinkedList", false, TestGenerationContext.getInstance().getClassLoaderForSUT());
            mapClasses.add(mapClazz);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return mapClasses;
    }

    private static Set<Class<?>> getConcreteClassesSet() {
        LinkedHashSet mapClasses = new LinkedHashSet();
        try {
            Class<?> setClazz = Class.forName("java.util.LinkedHashSet", false, TestGenerationContext.getInstance().getClassLoaderForSUT());
            mapClasses.add(setClazz);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return mapClasses;
    }

    private static Set<Class<?>> getConcreteClassesComparable() {
        LinkedHashSet comparableClasses = new LinkedHashSet();
        try {
            Class<?> comparableClazz = Class.forName("java.lang.Integer", false, TestGenerationContext.getInstance().getClassLoaderForSUT());
            comparableClasses.add(comparableClazz);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return comparableClasses;
    }

    private static int getPackageDistance(String className1, String className2) {
        String[] package1 = StringUtils.split(className1, '.');
        String[] package2 = StringUtils.split(className2, '.');
        int distance = 0;
        int same = 1;
        for (int num = 0; num < package1.length && num < package2.length && package1[num].equals(package2[num]); ++num) {
            ++same;
        }
        if (package1.length > same) {
            distance += package1.length - same;
        }
        if (package2.length > same) {
            distance += package2.length - same;
        }
        return distance;
    }

    private static class Pair {
        private final int recursion;
        private final GenericClass dependencyClass;

        public Pair(int recursion, Type dependencyClass) {
            this.recursion = recursion;
            this.dependencyClass = new GenericClass(dependencyClass);
        }

        public int getRecursion() {
            return this.recursion;
        }

        public GenericClass getDependencyClass() {
            return this.dependencyClass;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dependencyClass == null ? 0 : this.dependencyClass.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            return !(this.dependencyClass == null ? other.dependencyClass != null : !this.dependencyClass.equals(other.dependencyClass));
        }
    }
}

