/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.statistics;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.evosuite.Properties;
import org.evosuite.coverage.exception.ExceptionCoverageSuiteFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxTestsStoppingCondition;
import org.evosuite.rmi.ClientServices;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.statistics.StatisticsSender;
import org.evosuite.testsuite.TestSuiteChromosome;

public class StatisticsListener
implements SearchListener {
    private volatile BlockingQueue<Chromosome> individuals = new LinkedBlockingQueue<Chromosome>();
    private volatile boolean done = false;
    private volatile double bestFitness = Double.MAX_VALUE;
    private volatile boolean minimizing = true;
    private int numFitnessEvaluations = 0;
    private volatile Thread notifier = new Thread(){

        @Override
        public void run() {
            while (!StatisticsListener.this.done || !StatisticsListener.this.individuals.isEmpty()) {
                try {
                    Chromosome individual = (Chromosome)StatisticsListener.this.individuals.take();
                    StatisticsSender.sendIndividualToMaster(individual);
                }
                catch (InterruptedException e) {
                    StatisticsListener.this.done = true;
                }
            }
        }
    };
    private volatile long timeFromLastGenerationUpdate = 0L;

    public StatisticsListener() {
        Sandbox.addPriviligedThread(this.notifier);
        this.notifier.start();
    }

    @Override
    public void iteration(GeneticAlgorithm<?> algorithm) {
        long elapsed = System.currentTimeMillis() - this.timeFromLastGenerationUpdate;
        if (elapsed > Properties.TIMELINE_INTERVAL) {
            this.timeFromLastGenerationUpdate = System.currentTimeMillis();
            this.individuals.offer(algorithm.getBestIndividual());
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.TotalExceptionsTimeline, ExceptionCoverageSuiteFitness.getMaxExceptionsCovered());
        }
    }

    @Override
    public void searchFinished(GeneticAlgorithm<?> algorithm) {
        this.individuals.offer(algorithm.getBestIndividual());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Statements_Executed, MaxStatementsStoppingCondition.getNumExecutedStatements());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Tests_Executed, MaxTestsStoppingCondition.getNumExecutedTests());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Generations, algorithm.getAge());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Fitness_Evaluations, this.numFitnessEvaluations);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.TotalExceptionsTimeline, ExceptionCoverageSuiteFitness.getMaxExceptionsCovered());
        if (algorithm.getBestIndividual() instanceof TestSuiteChromosome) {
            this.reportTestSuiteResult((TestSuiteChromosome)algorithm.getBestIndividual());
        }
        this.done = true;
        try {
            this.notifier.join(3000L);
        }
        catch (InterruptedException e) {
            this.notifier.interrupt();
            Thread.currentThread().interrupt();
        }
    }

    private void reportTestSuiteResult(TestSuiteChromosome testSuite) {
    }

    @Override
    public void searchStarted(GeneticAlgorithm<?> algorithm) {
        this.done = false;
        if (algorithm.getFitnessFunction().isMaximizationFunction()) {
            this.bestFitness = 0.0;
            this.minimizing = false;
        } else {
            this.bestFitness = Double.MAX_VALUE;
            this.minimizing = true;
        }
    }

    @Override
    public void fitnessEvaluation(Chromosome individual) {
        ++this.numFitnessEvaluations;
        double fitness = individual.getFitness();
        if (this.minimizing) {
            if (fitness < this.bestFitness) {
                this.bestFitness = fitness;
                this.individuals.offer(individual);
            }
        } else if (fitness > this.bestFitness) {
            this.bestFitness = fitness;
            this.individuals.offer(individual);
        }
    }

    @Override
    public void modification(Chromosome individual) {
    }
}

