/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.statistics.backend;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.statistics.OutputVariable;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.statistics.backend.StatisticsBackend;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.HtmlAnalyzer;
import org.evosuite.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTMLStatisticsBackend
implements StatisticsBackend {
    protected static final Logger logger = LoggerFactory.getLogger(HTMLStatisticsBackend.class);
    protected static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";
    protected static final HtmlAnalyzer html_analyzer = new HtmlAnalyzer();

    @Override
    public void writeData(Chromosome result, Map<String, OutputVariable<?>> data) {
        if (!Properties.HTML) {
            return;
        }
        new File(HTMLStatisticsBackend.getReportDir().getAbsolutePath() + "/img").mkdirs();
        new File(HTMLStatisticsBackend.getReportDir().getAbsolutePath() + "/html/files/").mkdirs();
        new File(HTMLStatisticsBackend.getReportDir().getAbsolutePath() + "/data/").mkdirs();
        new File(HTMLStatisticsBackend.getReportDir().getAbsolutePath() + "/files/").mkdirs();
        HTMLStatisticsBackend.copyFile("prettify.js");
        HTMLStatisticsBackend.copyFile("prettify.css");
        HTMLStatisticsBackend.copyFile("style.css");
        HTMLStatisticsBackend.copyFile("foldButton.js");
        HTMLStatisticsBackend.copyFile("foldButton.css");
        HTMLStatisticsBackend.copyFile("jquery.js");
        HTMLStatisticsBackend.copyFile("detected.png");
        HTMLStatisticsBackend.copyFile("not_detected.png");
        HTMLStatisticsBackend.copyFile("img01.jpg");
        HTMLStatisticsBackend.copyFile("img02.jpg");
        HTMLStatisticsBackend.copyFile("img03.jpg");
        HTMLStatisticsBackend.copyFile("img04.png");
        HTMLStatisticsBackend.copyFile("evosuite.png");
        File file = new File(HTMLStatisticsBackend.getReportDir(), "report-generation.html");
        StringBuffer report = new StringBuffer();
        if (file.exists()) {
            List<String> lines = Utils.readFile(file);
            for (String line : lines) {
                if (line.contains("<!-- EVOSUITE INSERTION POINT -->")) break;
                report.append(line);
            }
        } else {
            HTMLStatisticsBackend.writeHTMLHeader(report, Properties.PROJECT_PREFIX);
            report.append("<div id=\"header\">\n<div id=\"logo\">");
            report.append("\n</div><br></div>");
            try {
                report.append("Run on " + InetAddress.getLocalHost().getHostName() + "\n");
            }
            catch (Exception e) {
                // empty catch block
            }
            report.append("<div id=\"page\">\n");
            report.append("<div id=\"page-bgtop\">\n");
            report.append("<div id=\"page-bgbtm\">\n");
            report.append("<div id=\"content\">\n");
            report.append("<div id=\"post\">");
            report.append("<h2 class=\"title\">Test generation runs:</h2>\n");
            report.append("<div style=\"clear: both;\">&nbsp;</div><div class=\"entry\">");
            report.append("<table cellspacing=0>");
            report.append("<tr class=\"top bottom\">");
            report.append("<td>Date</td>");
            report.append("<td>Time</td>");
            report.append("<td>Coverage</td>");
            report.append("<td>Class</td>");
            report.append("</tr>\n");
        }
        this.writeRunTable((TestSuiteChromosome)result, data, report);
        report.append("</div></div></div></div></div></div>");
        HTMLStatisticsBackend.writeHTMLFooter(report);
        Utils.writeFile(report.toString(), file);
    }

    public static void copyFile(URL src, File dest) {
        try {
            int len;
            InputStream in = src.openStream();
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyFile(String name) {
        URL systemResource = ClassLoader.getSystemResource("src/main/resources/report/" + name);
        logger.debug("Copying from resource: " + systemResource);
        HTMLStatisticsBackend.copyFile(systemResource, new File(HTMLStatisticsBackend.getReportDir(), "files/" + name));
        HTMLStatisticsBackend.copyFile(systemResource, new File(HTMLStatisticsBackend.getReportDir().getAbsolutePath() + "/html/files/" + name));
    }

    public static File getReportDir() throws RuntimeException {
        boolean created;
        File dir = new File(Properties.REPORT_DIR);
        if (!dir.exists() && !(created = dir.mkdirs())) {
            String msg = "Cannot create report dir: " + Properties.REPORT_DIR;
            logger.error(msg);
            throw new RuntimeException(msg);
        }
        return dir;
    }

    public static void writeHTMLHeader(StringBuffer buffer, String title) {
        buffer.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">\n");
        buffer.append("<html>\n");
        buffer.append("<head>\n");
        buffer.append("<title>\n");
        buffer.append(title);
        buffer.append("\n</title>\n");
        buffer.append("<link href=\"files/prettify.css\" type=\"text/css\" rel=\"stylesheet\" />\n");
        buffer.append("<link href=\"files/style.css\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\" />\n");
        buffer.append("<script type=\"text/javascript\" src=\"files/prettify.js\"></script>\n");
        buffer.append("<script type=\"text/javascript\" src=\"files/jquery.js\"></script>\n");
        buffer.append("<script type=\"text/javascript\" src=\"files/foldButton.js\"></script>\n");
        buffer.append("<script type=\"text/javascript\">\n");
        buffer.append("  $(document).ready(function() {\n");
        buffer.append("    $('H2#tests').foldButton();\n");
        buffer.append("    $('H2#source').foldButton();\n");
        buffer.append("    $('H2#parameters').foldButton();\n");
        buffer.append("  });");
        buffer.append("</script>\n");
        buffer.append("<link href=\"files/foldButton.css\" rel=\"stylesheet\" type=\"text/css\">\n");
        buffer.append("</head>\n");
        buffer.append("<body onload=\"prettyPrint()\">\n");
        buffer.append("<div id=\"wrapper\">\n");
        buffer.append("<img src=\"files/evosuite.png\" height=\"40\"/>\n");
    }

    public static void writeHTMLFooter(StringBuffer buffer) {
        buffer.append("</div>\n");
        buffer.append("</body>\n");
        buffer.append("</html>\n");
    }

    protected void writeRunTable(TestSuiteChromosome suite, Map<String, OutputVariable<?>> data, StringBuffer buffer) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        buffer.append("<tr>");
        buffer.append("<td>");
        buffer.append(sdf.format(new Date()));
        buffer.append("</td>");
        buffer.append("<td>");
        if (data.containsKey(RuntimeVariable.Total_Time.name())) {
            long duration = (Long)data.get(RuntimeVariable.Total_Time.name()).getValue() / 1000L;
            buffer.append(String.format("%d:%02d:%02d", duration / 3600L, duration % 3600L / 60L, duration % 60L));
        } else {
            buffer.append("UNKNOWN");
        }
        buffer.append("</td>");
        buffer.append("<td>");
        Double coverage = (Double)this.getOutputVariableValue(data, RuntimeVariable.Coverage.name());
        buffer.append(coverage != null ? NumberFormat.getPercentInstance().format(coverage) : "UNKNOWN");
        buffer.append("</td>");
        buffer.append("<td><a href=\"html/");
        String filename = this.writeRunPage(suite, data);
        buffer.append(filename);
        buffer.append("\">");
        buffer.append(data.get("TARGET_CLASS").getValue());
        buffer.append("</tr>\n");
        buffer.append("<!-- EVOSUITE INSERTION POINT -->\n");
        buffer.append("<tr class=\"top\"><td colspan=\"3\">&nbsp;<td></tr>\n");
        buffer.append("</table>");
    }

    protected String writeRunPage(TestSuiteChromosome suite, Map<String, OutputVariable<?>> data) {
        int linecount;
        StringBuffer sb = new StringBuffer();
        String className = (String)data.get("TARGET_CLASS").getValue();
        HTMLStatisticsBackend.writeHTMLHeader(sb, className);
        sb.append("<br><br><h2 class=title>Summary</h2>\n");
        sb.append("<ul><li>Target class: ");
        sb.append(this.getOutputVariableValue(data, "TARGET_CLASS"));
        sb.append(": ");
        sb.append(suite.getCoverage());
        sb.append("</ul>\n");
        this.writeResultTable(suite, sb, data);
        sb.append("<div id=\"page\">\n");
        sb.append("<div id=\"page-bgtop\">\n");
        sb.append("<div id=\"page-bgbtm\">\n");
        sb.append("<div id=\"content\">\n");
        sb.append("<div id=\"post\">\n");
        sb.append("<h2 class=title id=tests>Test suite</h2>\n");
        sb.append("<div class=tests>\n");
        int num = 0;
        for (TestChromosome testChromosome : suite.getTestChromosomes()) {
            TestCase test = testChromosome.getTestCase();
            sb.append("<h3>Test case ");
            sb.append(++num);
            sb.append("</h3>\n");
            sb.append("<pre class=\"prettyprint\" style=\"border: 1px solid #888;padding: 2px\">\n");
            linecount = 1;
            String code = null;
            code = testChromosome.getLastExecutionResult() != null ? test.toCode(testChromosome.getLastExecutionResult().exposeExceptionMapping()) : test.toCode();
            for (String line : code.split("\n")) {
                sb.append(String.format("<span class=\"nocode\"><a name=\"%d\">%3d: </a></span>", linecount, linecount));
                sb.append(StringEscapeUtils.escapeHtml4(line));
                ++linecount;
                sb.append("\n");
            }
            sb.append("</pre>\n");
        }
        sb.append("</div>");
        sb.append("<div id=\"post\">\n");
        OutputVariable<?> ov_covered_lines = data.get(RuntimeVariable.Covered_Lines.name());
        Set coveredLines = ov_covered_lines != null ? (Set)ov_covered_lines.getValue() : new HashSet();
        try {
            Iterable<String> source = html_analyzer.getClassContent(className);
            sb.append("<h2 class=title id=source>Source Code</h2>\n");
            sb.append("<div class=source>\n");
            sb.append("<p>");
            sb.append("<pre class=\"prettyprint\" style=\"border: 1px solid #888;padding: 2px\">");
            linecount = 1;
            for (String line : source) {
                sb.append(String.format("<span class=\"nocode\"><a name=\"%d\">%3d: </a></span>", linecount, linecount));
                if (coveredLines.contains(linecount)) {
                    sb.append("<span style=\"background-color: #ffffcc\">");
                    sb.append(StringEscapeUtils.escapeHtml4(line));
                    sb.append("</span>");
                } else {
                    sb.append(StringEscapeUtils.escapeHtml4(line));
                }
                sb.append("\n");
                ++linecount;
            }
            sb.append("</pre>\n");
            sb.append("</p>\n");
        }
        catch (Exception e) {
            // empty catch block
        }
        sb.append("</div>\n");
        sb.append("<div id=\"post\">\n");
        this.writeParameterTable(sb, data);
        sb.append("</div>\n");
        sb.append("<p><br><a href=\"../report-generation.html\">Back to Overview</a></p>\n");
        HTMLStatisticsBackend.writeHTMLFooter(sb);
        String filename = "report-" + className + "-" + this.getNumber(className) + ".html";
        File file = new File(HTMLStatisticsBackend.getReportDir().getAbsolutePath() + "/html/" + filename);
        Utils.writeFile(sb.toString(), file);
        return filename;
    }

    protected int getNumber(final String className) {
        int num = 0;
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("report-" + className) && name.endsWith(".html");
            }
        };
        ArrayList<String> filenames = new ArrayList<String>();
        File[] files = new File(HTMLStatisticsBackend.getReportDir().getAbsolutePath() + "/html").listFiles(filter);
        if (files != null) {
            for (File f : files) {
                filenames.add(f.getName());
            }
            while (filenames.contains("report-" + className + "-" + num + ".html")) {
                ++num;
            }
        }
        return num;
    }

    protected Object getOutputVariableValue(Map<String, OutputVariable<?>> data, String key) {
        OutputVariable<?> ov = data.get(key);
        return ov != null ? ov.getValue() : null;
    }

    protected void writeResultTable(TestSuiteChromosome suite, StringBuffer buffer, Map<String, OutputVariable<?>> data) {
        buffer.append("<ul>\n");
        buffer.append("<li>");
        buffer.append(suite.getFitness());
        buffer.append(" fitness evaluations, ");
        buffer.append(suite.getAge());
        buffer.append(" generations, ");
        buffer.append(this.getOutputVariableValue(data, RuntimeVariable.Statements_Executed.name()));
        buffer.append(" statements, ");
        buffer.append(suite.size());
        buffer.append(" tests.\n");
        buffer.append("<li>Covered " + this.getOutputVariableValue(data, RuntimeVariable.Covered_Branches.name()) + "/" + this.getOutputVariableValue(data, RuntimeVariable.Total_Branches.name()) + " branches, ");
        buffer.append("<li>Covered " + this.getOutputVariableValue(data, RuntimeVariable.Covered_Methods.name()) + "/" + this.getOutputVariableValue(data, RuntimeVariable.Total_Methods.name()) + " methods, ");
        buffer.append("<li>Covered " + this.getOutputVariableValue(data, RuntimeVariable.Covered_Goals.name()) + "/" + this.getOutputVariableValue(data, RuntimeVariable.Total_Goals.name()) + " total goals\n");
        if (data.containsKey(RuntimeVariable.MutationScore.name())) {
            buffer.append("<li>Mutation score: " + NumberFormat.getPercentInstance().format((Double)data.get(RuntimeVariable.MutationScore.name()).getValue()) + "\n");
        }
        buffer.append("</ul>\n");
    }

    protected void writeParameterTable(StringBuffer buffer, Map<String, OutputVariable<?>> data) {
        buffer.append("<h2 id=parameters>EvoSuite Parameters</h2>\n");
        buffer.append("<div class=statistics><ul>\n");
        for (String key : data.keySet()) {
            buffer.append("<li>" + key + ": " + data.get(key).getValue() + "\n");
        }
        buffer.append("</ul></div>\n");
    }
}

