/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.stubs;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class StubClassVisitor
extends ClassVisitor {
    private String className;

    public StubClassVisitor(ClassVisitor parent, String className) {
        super(327680, parent);
        this.className = className;
    }

    private void createConstructor(GeneratorAdapter mg, Method m) {
        mg.loadThis();
        mg.invokeConstructor(Type.getType(Object.class), m);
        mg.returnValue();
        mg.endMethod();
    }

    private String getTypeName(Type t) {
        switch (t.getSort()) {
            case 0: {
                return "Void";
            }
            case 1: {
                return "Boolean";
            }
            case 3: {
                return "Byte";
            }
            case 2: {
                return "Char";
            }
            case 8: {
                return "Double";
            }
            case 6: {
                return "Float";
            }
            case 5: {
                return "Int";
            }
            case 7: {
                return "Long";
            }
            case 4: {
                return "Short";
            }
            case 9: {
                return this.getTypeName(t.getElementType()) + "Array";
            }
            case 10: {
                String className = t.getClassName();
                if (className.equals("java.lang.String")) {
                    return "String";
                }
                return "Object";
            }
        }
        return "";
    }

    private String getReturnTypeDesc(Type t) {
        if (t.getSort() == 10) {
            return "Ljava/lang/Object;";
        }
        if (t.getSort() == 9) {
            return "[" + this.getReturnTypeDesc(t.getElementType());
        }
        return t.getDescriptor();
    }

    private void insertReturnCast(GeneratorAdapter mg, Method m) {
        if (m.getReturnType().getSort() == 10) {
            mg.checkCast(m.getReturnType());
        } else if (m.getReturnType().getSort() == 9 && m.getReturnType().getElementType().getSort() == 10) {
            try {
                java.lang.reflect.Method copyMethod = System.class.getMethod("arraycopy", Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE);
                mg.dup();
                mg.arrayLength();
                int arrayLengthPos = mg.newLocal(Type.INT_TYPE);
                mg.storeLocal(arrayLengthPos);
                mg.loadLocal(arrayLengthPos);
                mg.newArray(m.getReturnType().getElementType());
                int newArrayPos = mg.newLocal(m.getReturnType());
                mg.storeLocal(newArrayPos);
                mg.push(0);
                mg.loadLocal(newArrayPos);
                mg.push(0);
                mg.loadLocal(arrayLengthPos);
                mg.invokeStatic(Type.getType(System.class), Method.getMethod(copyMethod));
                mg.loadLocal(newArrayPos);
                mg.checkCast(m.getReturnType());
            }
            catch (Exception e) {
                System.out.println("Screw that");
            }
        }
    }

    private void createMethod(GeneratorAdapter mg, Method m) {
        String methodName = "getReturnValue" + this.getTypeName(m.getReturnType());
        String desc = "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)" + this.getReturnTypeDesc(m.getReturnType());
        mg.push(this.className);
        mg.push(m.getName() + m.getDescriptor());
        mg.loadArgArray();
        Type owner = Type.getType("org/evosuite/stubs/Stubs");
        Method method = new Method(methodName, desc);
        mg.invokeStatic(owner, method);
        this.insertReturnCast(mg, m);
        mg.returnValue();
        mg.endMethod();
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Method m = new Method(name, desc);
        GeneratorAdapter mg = new GeneratorAdapter(access, m, signature, new Type[0], this.cv);
        mg.visitCode();
        if (name.equals("<init>")) {
            this.createConstructor(mg, m);
        } else {
            this.createMethod(mg, m);
        }
        return null;
    }
}

