/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.classpath.ResourceList;
import org.evosuite.symbolic.expr.Constraint;

public class BranchCondition {
    private final String className;
    private final String methodName;
    private final int branchIndex;
    private final BranchCondition previousBranchCondition;
    private final Constraint<?> localConstraint;
    private final List<Constraint<?>> supportingConstraints;

    public BranchCondition(BranchCondition previousBranchCondition, String className, String methodName, int branchIndex, Constraint<?> localConstraint, List<Constraint<?>> supportingConstraints) {
        this.className = ResourceList.getClassNameFromResourcePath(className);
        this.methodName = methodName;
        this.branchIndex = branchIndex;
        this.previousBranchCondition = previousBranchCondition;
        this.localConstraint = localConstraint;
        this.supportingConstraints = supportingConstraints;
    }

    public String toString() {
        String ret = "";
        for (Constraint<?> c : this.supportingConstraints) {
            ret = ret + " " + c + "\n";
        }
        ret = ret + this.localConstraint;
        return ret;
    }

    public String getClassName() {
        return this.className;
    }

    public int getInstructionIndex() {
        return this.branchIndex;
    }

    public String getFullName() {
        return this.className + "." + this.methodName;
    }

    private BranchCondition getPreviousBranchCondition() {
        return this.previousBranchCondition;
    }

    public Set<Constraint<?>> getReachingConstraints() {
        HashSet constraints = new HashSet();
        constraints.addAll(this.supportingConstraints);
        for (BranchCondition current = this.previousBranchCondition; current != null; current = current.getPreviousBranchCondition()) {
            constraints.addAll(current.supportingConstraints);
            constraints.add(current.localConstraint);
        }
        return constraints;
    }

    public Constraint<?> getLocalConstraint() {
        return this.localConstraint;
    }

    public List<Constraint<?>> getSupportingConstraints() {
        return this.supportingConstraints;
    }
}

