/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

import edu.uta.cse.dsc.IVM;
import edu.uta.cse.dsc.MainConfig;
import edu.uta.cse.dsc.VM;
import edu.uta.cse.dsc.instrument.DscInstrumentingClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.SymbolicObserver;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.ExpressionExecutor;
import org.evosuite.symbolic.vm.ArithmeticVM;
import org.evosuite.symbolic.vm.CallVM;
import org.evosuite.symbolic.vm.HeapVM;
import org.evosuite.symbolic.vm.JumpVM;
import org.evosuite.symbolic.vm.LocalsVM;
import org.evosuite.symbolic.vm.OtherVM;
import org.evosuite.symbolic.vm.PathConstraint;
import org.evosuite.symbolic.vm.SymbolicEnvironment;
import org.evosuite.symbolic.vm.SymbolicFunctionVM;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.TestCaseExecutor;
import org.evosuite.testcase.TestChromosome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConcolicExecution {
    private static Logger logger = LoggerFactory.getLogger(ConcolicExecution.class);
    private static final DscInstrumentingClassLoader classLoader = new DscInstrumentingClassLoader();

    public static List<BranchCondition> getSymbolicPath(TestChromosome test) {
        TestChromosome dscCopy = (TestChromosome)test.clone();
        DefaultTestCase defaultTestCase = (DefaultTestCase)dscCopy.getTestCase();
        return ConcolicExecution.executeConcolic(defaultTestCase);
    }

    public static List<BranchCondition> executeConcolic(DefaultTestCase defaultTestCase) {
        logger.debug("Preparing concolic execution");
        MainConfig.setInstance();
        SymbolicEnvironment env = new SymbolicEnvironment(classLoader);
        PathConstraint pc = new PathConstraint();
        ArrayList<IVM> listeners = new ArrayList<IVM>();
        listeners.add(new CallVM(env, classLoader));
        listeners.add(new JumpVM(env, pc));
        listeners.add(new HeapVM(env, pc, classLoader));
        listeners.add(new LocalsVM(env));
        listeners.add(new ArithmeticVM(env, pc));
        listeners.add(new OtherVM(env));
        listeners.add(new SymbolicFunctionVM(env, pc));
        VM.vm.setListeners(listeners);
        VM.vm.startupConcolicExecution();
        defaultTestCase.changeClassLoader(classLoader);
        SymbolicObserver symbolicExecObserver = new SymbolicObserver(env);
        TestCaseExecutor.getInstance().addObserver(symbolicExecObserver);
        logger.info("Starting concolic execution");
        ExecutionResult result = new ExecutionResult(defaultTestCase, null);
        try {
            logger.debug("Executing test");
            long startConcolicExecutionTime = System.currentTimeMillis();
            result = TestCaseExecutor.getInstance().execute(defaultTestCase, Properties.CONCOLIC_TIMEOUT);
            long estimatedConcolicExecutionTime = System.currentTimeMillis() - startConcolicExecutionTime;
            DSEStats.reportNewConcolicExecutionTime(estimatedConcolicExecutionTime);
            MaxStatementsStoppingCondition.statementsExecuted(result.getExecutedStatements());
        }
        catch (Exception e) {
            logger.error("Exception during concolic execution {}", e);
            return new ArrayList<BranchCondition>();
        }
        VM.vm.cleanupConcolicExecution();
        List<BranchCondition> branches = pc.getBranchConditions();
        logger.info("Concolic execution ended with " + branches.size() + " branches collected");
        if (!result.noThrownExceptions()) {
            int idx = result.getFirstPositionOfThrownException();
            logger.info("Exception thrown: " + result.getExceptionThrownAtPosition(idx));
        }
        ConcolicExecution.logNrOfConstraints(branches);
        logger.debug("Cleaning concolic execution");
        TestCaseExecutor.getInstance().removeObserver(symbolicExecObserver);
        return branches;
    }

    private static void logNrOfConstraints(List<BranchCondition> branches) {
        int nrOfConstraints = 0;
        ExpressionExecutor exprExecutor = new ExpressionExecutor();
        for (BranchCondition branchCondition : branches) {
            for (Constraint<?> supporting_constraint : branchCondition.getSupportingConstraints()) {
                supporting_constraint.getLeftOperand().accept(exprExecutor, null);
                supporting_constraint.getRightOperand().accept(exprExecutor, null);
                ++nrOfConstraints;
            }
            Constraint<?> constraint = branchCondition.getLocalConstraint();
            constraint.getLeftOperand().accept(exprExecutor, null);
            constraint.getRightOperand().accept(exprExecutor, null);
            ++nrOfConstraints;
        }
        logger.debug("nrOfConstraints=" + nrOfConstraints);
    }
}

