/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.expr.BinaryExpression;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.UnaryExpression;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.solver.ConstraintCache;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.SolverFactory;
import org.evosuite.testcase.BooleanPrimitiveStatement;
import org.evosuite.testcase.BytePrimitiveStatement;
import org.evosuite.testcase.CharPrimitiveStatement;
import org.evosuite.testcase.IntPrimitiveStatement;
import org.evosuite.testcase.LongPrimitiveStatement;
import org.evosuite.testcase.NumericalPrimitiveStatement;
import org.evosuite.testcase.PrimitiveStatement;
import org.evosuite.testcase.ShortPrimitiveStatement;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcolicMutation {
    protected static final Logger logger = LoggerFactory.getLogger(ConcolicMutation.class);

    public static TestCase negateCondition(BranchCondition condition, TestCase test) {
        List<Constraint<?>> constraints = new LinkedList();
        constraints.addAll(condition.getReachingConstraints());
        Constraint<?> c = condition.getLocalConstraint();
        Constraint<?> targetConstraint = c.negate();
        constraints.add(targetConstraint);
        if (!targetConstraint.isSolveable()) {
            logger.info("Found unsolvable constraint: " + targetConstraint);
            return null;
        }
        int size = constraints.size();
        if (size > 0) {
            constraints = ConcolicMutation.reduce(constraints);
        }
        Solver solver = SolverFactory.getInstance().buildNewSolver();
        Map<String, Object> values = ConstraintCache.getInstance().solve(solver, constraints);
        if (values != null) {
            TestCase newTest = test.clone();
            for (String key : values.keySet()) {
                Object val = values.get(key);
                if (val != null) {
                    if (val instanceof Long) {
                        NumericalPrimitiveStatement bp;
                        Long value = (Long)val;
                        String name = key.replace("__SYM", "");
                        logger.debug("New value for " + name + " is " + value);
                        PrimitiveStatement<?> p = ConcolicMutation.getStatement(newTest, name);
                        assert (p != null);
                        if (p instanceof BooleanPrimitiveStatement) {
                            bp = (BooleanPrimitiveStatement)p;
                            bp.setValue(value.intValue() > 0);
                            continue;
                        }
                        if (p instanceof CharPrimitiveStatement) {
                            CharPrimitiveStatement cp = (CharPrimitiveStatement)p;
                            cp.setValue(Character.valueOf((char)value.intValue()));
                            continue;
                        }
                        if (p instanceof BytePrimitiveStatement) {
                            bp = (BytePrimitiveStatement)p;
                            bp.setValue((byte)value.intValue());
                            continue;
                        }
                        if (p instanceof ShortPrimitiveStatement) {
                            ShortPrimitiveStatement sp = (ShortPrimitiveStatement)p;
                            sp.setValue((short)value.intValue());
                            continue;
                        }
                        if (p instanceof LongPrimitiveStatement) {
                            LongPrimitiveStatement lp = (LongPrimitiveStatement)p;
                            lp.setValue(value);
                            continue;
                        }
                        assert (p instanceof IntPrimitiveStatement);
                        IntPrimitiveStatement ip = (IntPrimitiveStatement)p;
                        ip.setValue(value.intValue());
                        continue;
                    }
                    logger.debug("New value is not long " + val);
                    continue;
                }
                logger.debug("New value is null");
            }
            return newTest;
        }
        logger.debug("Got null :-(");
        return null;
    }

    private static PrimitiveStatement<?> getStatement(TestCase test, String name) {
        for (StatementInterface statement : test) {
            if (!(statement instanceof PrimitiveStatement) || !statement.getReturnValue().getName().equals(name)) continue;
            return (PrimitiveStatement)statement;
        }
        return null;
    }

    private static List<Constraint<?>> reduce(List<Constraint<?>> constraints) {
        Constraint<?> target = constraints.get(constraints.size() - 1);
        Set<Variable<?>> dependencies = ConcolicMutation.getVariables(target);
        LinkedList coi = new LinkedList();
        coi.add(target);
        block0: for (int i = constraints.size() - 2; i >= 0; --i) {
            Constraint<?> constraint = constraints.get(i);
            Set<Variable<?>> variables = ConcolicMutation.getVariables(constraint);
            for (Variable<?> var : dependencies) {
                if (!variables.contains(var)) continue;
                dependencies.addAll(variables);
                coi.addFirst(constraint);
                continue block0;
            }
        }
        return coi;
    }

    private static Set<Variable<?>> getVariables(Constraint<?> constraint) {
        HashSet variables = new HashSet();
        ConcolicMutation.getVariables(constraint.getLeftOperand(), variables);
        ConcolicMutation.getVariables(constraint.getRightOperand(), variables);
        return variables;
    }

    private static void getVariables(Expression<?> expr, Set<Variable<?>> variables) {
        if (expr instanceof Variable) {
            variables.add((Variable)expr);
        } else if (expr instanceof BinaryExpression) {
            BinaryExpression bin = (BinaryExpression)((Object)expr);
            ConcolicMutation.getVariables(bin.getLeftOperand(), variables);
            ConcolicMutation.getVariables(bin.getRightOperand(), variables);
        } else if (expr instanceof UnaryExpression) {
            UnaryExpression un = (UnaryExpression)((Object)expr);
            ConcolicMutation.getVariables(un.getOperand(), variables);
        } else if (expr instanceof Constraint) {
            // empty if block
        }
    }
}

