/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr;

import org.evosuite.Properties;
import org.evosuite.symbolic.ConstraintTooLongException;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.ConstraintVisitor;
import org.evosuite.symbolic.expr.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RealConstraint
extends Constraint<Double> {
    static Logger log = LoggerFactory.getLogger(RealConstraint.class);
    private static final long serialVersionUID = 6021027178547577289L;
    private final Expression<Double> left;
    private final Comparator cmp;
    private final Expression<Double> right;

    public RealConstraint(Expression<Double> left, Comparator cmp, Expression<Double> right) {
        this.left = left;
        this.cmp = cmp;
        this.right = right;
        if (this.getSize() > Properties.DSE_CONSTRAINT_LENGTH) {
            DSEStats.reportConstraintTooLong(this.getSize());
            throw new ConstraintTooLongException(this.getSize());
        }
    }

    @Override
    public Comparator getComparator() {
        return this.cmp;
    }

    @Override
    public Expression<Double> getLeftOperand() {
        return this.left;
    }

    @Override
    public Expression<Double> getRightOperand() {
        return this.right;
    }

    public String toString() {
        return this.left + this.cmp.toString() + this.right;
    }

    @Override
    public Constraint<Double> negate() {
        return new RealConstraint(this.left, this.cmp.not(), this.right);
    }

    @Override
    public <K, V> K accept(ConstraintVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

